package com.mini.framework.util.cache.annotation.springboot2;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.paas.SiteIdReader;

public class MultiSiteCustomCacheKeyPrefix<S> extends CustomCacheKeyPrefix{

	private SiteIdReader<S> siteIdReader;
	
	public MultiSiteCustomCacheKeyPrefix(String cacheNamespace,SiteIdReader<S> siteIdReader) {
		super(cacheNamespace);
		this.siteIdReader = siteIdReader;
		AssertUtil.assertNotFatal(this.siteIdReader!=null, "siteIdReader前缀没有配置");
	}
	
	@Override
	public String fillKeyPrefix(String key) {
		AssertUtil.assertNotFatal(cacheNamespace!=null, "cacheNamespace前缀没有配置");
		// 应该允许siteid为空,如果为空使用empty代替
		String siteKey = siteIdReader.queryCurrSiteId().map(Object::toString).orElse("empty");
		return String.join(saveSplit, cacheNamespace,"site",siteKey,key,"");
	}

}
