package com.mini.framework.util.cache.prepare.merge;

import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.util.cache.prepare.merge.data.PersistenceIncrementExecutor;
import com.mini.framework.util.cache.prepare.merge.data.PrepareAtomCacheExecutor;
import com.mini.framework.util.cache.prepare.merge.data.WorkDelayLock;
import com.mini.framework.util.function.LazyAssignBean;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.thread.AbstractAsyncThreadExecutor;
import com.mini.framework.util.thread.RunnableThrowableHandler;
import com.mini.framework.util.thread.ThreadQuietSleep;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

/**
 * 计数器前置缓存
 * 增量预先缓存再异步合并
 * @author jayheo
 */
public class IncrementPrepareCacheAsyncMergeFlow {

    private static Logger logger = LogManager.getLogger(IncrementPrepareCacheAsyncMergeFlow.class);


    /**
     * 工作流的名字
     * */
    private String flowName;

    /**
     * 异步执行器
     * */
    private AbstractAsyncThreadExecutor asyncExecutor;

    /**
     * 预先原子处理
     * */
    private PrepareAtomCacheExecutor prepareAtomExecutor;

    /**
     * 分布式锁
     * */
    private WorkDelayLock lock;

    public IncrementPrepareCacheAsyncMergeFlow(String flowName,AbstractAsyncThreadExecutor asyncExecutor, PrepareAtomCacheExecutor prepareCacheExecute, WorkDelayLock lock) {
        //TODO 要添加非空断言
        this.flowName = flowName;
        this.asyncExecutor = asyncExecutor;
        this.prepareAtomExecutor = prepareCacheExecute;
        this.lock = lock;
    }

    public <E extends CustomException> void executeFlow(String key, int increment, PersistenceIncrementExecutor persistenceIncrement, Function<String,E> exceptionSupplier) throws E{
        prepareSurplusCheck(key,increment,persistenceIncrement,exceptionSupplier);
        executeWriteIncrement(key,increment,persistenceIncrement);
    }

    /**
     * 前面剩余量检查
     * */

    public <E extends CustomException> void prepareSurplusCheck(String key, int increment, PersistenceIncrementExecutor persistenceIncrement, Function<String,E> exceptionSupplier) throws E{
        if(increment<0){
            long currentCachedSurplus = prepareAtomExecutor.querySurplus(key);
            long currentSwapStoreCachedSurplus = prepareAtomExecutor.querySwapStoreSurplus(key);
            long currentPersistenceSurplus = persistenceIncrement.querySurplus(key);

            long surplusIfExecute = currentCachedSurplus + currentSwapStoreCachedSurplus + currentPersistenceSurplus + increment;
            logger.debug(String.format("flow:" + flowName + " 通过prepareCheck方法 得到 surplusIfExecute = currentCachedSurplus(%s) + currentSwapStoreCachedSurplus(%s) + currentPersistenceSurplus(%s) + increment(%s) = %s"
                    ,currentCachedSurplus,currentSwapStoreCachedSurplus , currentPersistenceSurplus,increment,surplusIfExecute));
            if(surplusIfExecute < 0) {
                throw exceptionSupplier.apply(String.format("flow:%s 当前key:[%s],的现有量为:[%s]不可以应用增量:[%s]",flowName, key,currentCachedSurplus  + currentSwapStoreCachedSurplus + currentPersistenceSurplus,increment));
            }
        }else{
            logger.debug(String.format("flow:%s 预先剩余量检查,key:[%s],increment:[%s],increment>=0 不做剩余量检查了",flowName,key,increment));
        }

    }

    /**
     * 执行写数据的流程。
     *
     * TODO 这里如果写一个流程就好了。比如使用markdown语法写出流程写一个流程
     * */
    public void executeWriteIncrement(String key, int increment, PersistenceIncrementExecutor persistenceIncrement){
        LazyAssignBean<Runnable> runnableBean = LazyAssignBean.create();

        //前置处理
        long mainAfterIncrement = prepareAtomExecutor.writeIncrement(key,increment);
        // 创建执行异步
        Runnable runnable =()->{
            String workName = Thread.currentThread().getName();
            Event5WBuilder event = Event5WBuilder.event(2,"executeWriteIncrement")
                    .who("flow:%s 线程:[%s]",flowName,workName)
                    .what("从预缓存中同步key:[%s]的增量:[%s]到数据库,mainAfterSurplus:[%s]",key,increment,mainAfterIncrement);
            Optional<String> lockedOptional = lock.triesLock(key,workName);
            if(lockedOptional.isPresent()){
                logger.debug(event.why("当前已有别线程:[%s]标记同步工作",lockedOptional.get())
                        .result("什么都不用做直接结束"));
            }else{
                logger.info(event.why("当前没有别的线程标记同步工作，可以工作").how("尝试从预缓存中同步"));
                ThreadQuietSleep.sleepMillisOrRun(1000L ,event.result("线程延迟1000毫秒被唤醒,继续工作").create());
                int historySwapStoreSurplus = prepareAtomExecutor.cutSwapStoreSurplus(key);
                logger.debug(event.result("原来的交换区数量为:[%s],现已清零",historySwapStoreSurplus));
                int currentCachedSurplus = prepareAtomExecutor.cutSurplus(key);
                int requireCorrectIncrement = - currentCachedSurplus;
                prepareAtomExecutor.writeSwapStoreIncrement(key,currentCachedSurplus);
                if(requireCorrectIncrement==0){
                    logger.debug(event.why("从redis中截取出需要修正的数字为0").result("什么都不用做"));
                }else{
                    logger.info(event.why("从redis中截取出剩余量:[%s],计算出需要修正的数字为:[%s]",currentCachedSurplus,requireCorrectIncrement)
                            .result("继续尝试操作预缓存和持久层"));
                    persistenceIncrement.writeIncrement(key,currentCachedSurplus,error->{
                        logger.debug(event.why("尝试操作预缓存和持久层失败了").result("现在去尝试反向写入预缓存中"),error);
                        logger.info(event.why("尝试操作预缓存和持久层失败了,error:[%s]",error.getMessage()).result("现在去尝试反向写入预缓存中"));
                        prepareAtomExecutor.writeIncrement(key,currentCachedSurplus);
                    });
                    prepareAtomExecutor.cutSwapStoreSurplus(key);
                    lock.releaseLock(key);
                    asyncExecutor.execute(runnableBean.showBean());
                }
                prepareAtomExecutor.cutSwapStoreSurplus(key);
                lock.releaseLock(key);
            }

        };
        runnable = RunnableThrowableHandler.assignLogError(runnable,"flow:%s executeWriteIncrement错误,key:[%s],increment:[%s]",flowName,key,increment);
        runnableBean.initBean(runnable);
        asyncExecutor.execute(runnable);
    }

}
