package com.mini.framework.util.cache.prepare.merge.data;

import java.util.function.Consumer;

/**
 * 持久层的增量操作执行者
 * 用来操作数据库的原子加操作
 * @author jayheo
 */
public interface PersistenceIncrementExecutor {

    /**
     * 执行写入增量的操作
     *
     * */
    void writeIncrement(String key, int increment, Consumer<Throwable> whenThrowable);



    /**
     * 查询剩余量
     * */
    long querySurplus(String key);

}
