package com.mini.framework.util.code;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.util.asserts.AssertUtil;


/**
 * #标准名词说明#DevCodeDescJavaFile:开发代码描述之java文件;
 * #标准名词说明@desc:描述;
 * @author jayheo
 *
 */
public class DevCodeDescJavaFile {

	private String name;
	
	private String packagePath;
	
	private String projectName;
	
	private List<DevCodeDescPoint> points;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPackagePath() {
		return packagePath;
	}

	public void setPackagePath(String packagePath) {
		this.packagePath = packagePath;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public List<DevCodeDescPoint> getPoints() {
		return points;
	}

	public void setPoints(List<DevCodeDescPoint> points) {
		this.points = points;
	}
	
	
	public static DevCodeDescJavaFile fromUtf8File(String filePath){
		AssertUtil.assertMethodRequire(filePath, "filePath");
		return fromUtf8File(new File(filePath));
	}
	public static DevCodeDescJavaFile fromUtf8File(File file){
		AssertUtil.assertMethodRequire(file, "file");
		DevCodeDescJavaFile javaFile = new DevCodeDescJavaFile();
		//TODO 这里解析要改一下
		javaFile.name = file.getName();
		//TODO 这里解析要改一下
		javaFile.packagePath = file.getAbsolutePath();
		try {
			List<String> lines = FileUtils.readLines(file, "utf-8");
			javaFile.points = lines.stream().map(DevCodeDescPoint::fromLine).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
			return javaFile;
		} catch (IOException e) {
			throw new HandleIOException(e, "读文件:[%s]时出错", file.getName());
		}
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
}
