package com.mini.framework.util.code;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.util.asserts.AssertUtil;

public class DevCodeDescPoint {
	
	private String code;
	
	private String desc;

	private String line;

	public String getLine() {
		return line;
	}

	public void setLine(String line) {
		this.line = line;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}
	
	public DevCodeDescPoint() {
		
	}
	public DevCodeDescPoint(String code, String desc, String line) {
		super();
		this.code = code;
		this.desc = desc;
		this.line = line;
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	public static Optional<DevCodeDescPoint> fromLine(String line){
		AssertUtil.assertMethodRequire(line, "line");
		Matcher match = Pattern.compile(lineRegex).matcher(line);
		if(match.find()){
			String code = match.group(1);
			String desc = match.group(2);
			return Optional.of(new DevCodeDescPoint(code,desc,line));
		}else{
			return Optional.empty(); 
		}
	}

	public final static String lineRegex = "#标准名词说明@(.*):(.*);";

}
