package com.mini.framework.util.colony;

import java.util.List;
import java.util.stream.Collectors;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;

import com.mini.framework.util.aspect.AspectBeanUtil;

/**
 * 单点操作注解支持
 * @author jayheo
 *
 */
public class SinglePointOptAnnotationSupport {
	
	private Logger logger = LogManager.getLogger(SinglePointOptAnnotationSupport.class);
	
	private DelayLockHelper delayIncLockHelper;
	
	public SinglePointOptAnnotationSupport(DelayLockHelper delayIncLockHelper) {
		super();
		this.delayIncLockHelper = delayIncLockHelper;
	}

	@Pointcut("@annotation(com.mini.framework.util.colony.SyncLockMethod)")
	public void point(){
		
	}
	
	@Around("point()")
	public Object around(ProceedingJoinPoint pjp) throws Throwable{
		//AopUtils
		SyncLockMethod spMethod = AspectBeanUtil.getAnnotation(pjp, SyncLockMethod.class);
		String key = spMethod.lockKey();
		List<String> params = AspectBeanUtil.listParam(pjp, SyncMethodKeyParam.class)
				.stream().map(SyncMethodKeyParam::showSyncKey).collect(Collectors.toList());
		params.add(0,key);
		String[] keys = params.toArray(new String[]{});
		int delay = spMethod.lockDelay();
		boolean lock = delayIncLockHelper.getLock(delay,keys);
		if(lock){
			try{
				return pjp.proceed();
			}finally{
				if(spMethod.endRelease()){
					delayIncLockHelper.releaseLock(keys);
				}
			}
		}
		logger.debug("分布式锁key:{}被锁住不执行方法",delayIncLockHelper.createKey(keys));
		//TODO logger.
		return null;
	}

}
