package com.mini.framework.util.export;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mini.framework.util.date.DateUtil;
import com.mini.framework.util.file.ExcelUtil;
import com.mini.framework.util.function.PredicateSpread;
import com.mini.framework.util.string.gson.GsonDataReader;

/**
 * excel导出的支持
 * @author jayheo
 *
 */
public class ExcelExportSupport extends GsonDataReader{

	/**
	 * 创建一个数据对象
	 * @param data
	 * @return
	 */
	public static ExcelExportSupport build(Object data){
		ExcelExportSupport ins = new ExcelExportSupport();
		ins.init(data);
		return ins;
	}
	
	@Override
	protected Gson currGsonUtil() {
		//TODO 由于一开始在gson读取的时间，时间已被序列化了，所以这时序列化时间无作用，这里是个bug
		GsonBuilder builder = new GsonBuilder().setDateFormat(DateFormat.LONG)
		.registerTypeAdapter(Date.class, new JsonSerializer<Date>() {
			@Override
			public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
				return new JsonPrimitive(DateUtil.toSecondsString(src));
			}
		});
		return builder.disableHtmlEscaping().create();
	}
	
	
	/**
	 * 以字节数组的方式导出文件
	 * @param listNamePath
	 * @param columns
	 * @return
	 */
	public byte[] exportAsBytes(String listNamePath, List<ExcelColumnDeclare> columns){
		columns = columns.stream().filter(PredicateSpread.ofNegate(ExcelColumnDeclare::skip)).collect(Collectors.toList());
		int columnsSize = columns.size();
		LinkedHashMap<String, String> titles = new LinkedHashMap<>();
		columns = columns.stream().sorted(Comparator.comparing(ExcelColumnDeclare::sorter)).collect(Collectors.toList());
		List<String> dataPaths = columns.stream().map(ExcelColumnDeclare::dataPath).collect(Collectors.toList());
		List<Map<String, Object>> listMapDataForOut = getFromListFrame(listNamePath, dataPaths);
		//这里保证了  listMapDataForOut 和 dataRows 一样长。
		List<Map<String, String>> dataRows = listMapDataForOut.stream()
				.map(item-> (Map<String ,String>) new HashMap<String, String>(columnsSize))
				.collect(Collectors.toList());

		for (int columnIndex = 0; columnIndex < columns.size(); columnIndex++) {
			String columnKey = "column" + columnIndex;
			ExcelColumnDeclare column = columns.get(columnIndex);
			String columnDataPath = column.dataPath();
			titles.put(columnKey,column.title());

			for (int rowIndex = 0; rowIndex < listMapDataForOut.size(); rowIndex++) {
				// get方法不会出现因为前面保证了 listMapDataForOut 和 dataRows 的长度一样。
				Map<String, Object> mapDataForOut = listMapDataForOut.get(rowIndex);
				Map<String, String> dataRow = dataRows.get(rowIndex);
				String outValue = Optional.ofNullable(mapDataForOut.get(columnDataPath))
						//TODO 这次转化担心会有点问题。先这么做，
						.map(Object::toString)
						.map(ExcelColumnDeclare.Support.contentSupplierFromOrigin(column))
						.orElse(column.defaultValue());
				dataRow.put(columnKey,outValue);
			}

		}
		return ExcelUtil.writeToByte(titles, dataRows);
	}
	
	
}
