package com.mini.framework.util.generic.define;


import com.mini.framework.util.asserts.AssertUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;

/**
 * long的list集合 这种写法是解决泛型带来的部分参数不明确的影响<BR>
 * 等价于<br>
 * @see List<Long>
 * @author jayheo
 */
public class ListLong {

    /**
     * 初始值，不可以被修改的。
     */
    private final List<Long> value;

    public ListLong(List<Long> value) {
        AssertUtil.assertMethodRequire(value,"value");
        this.value = value;
    }

    public static ListLong of(long... longs){
        return of(LongStream.of(longs).boxed().collect(Collectors.toSet()));
    }

    public static ListLong of(Long... longs){
        return of(Stream.of(longs).collect(Collectors.toSet()));
    }


    public static ListLong of(Collection<Long> coll){
        return of(new ArrayList<>(coll));
    }

    public static <L> ListLong of(Function<L,Long> longGetter, Collection<L> coll){
        return of(coll.stream()
                .map(longGetter)
                .collect(Collectors.toList()));
    }

    /**
     * 复制出一个副本
     * @return
     */
    public ListLong copy(){
        return ListLong.of(out());
    }


    /**
     * 输出
     * @return
     */
    public List<Long> out(){
        return value;
    }


    /**
     * 返回一个stream
     * @return
     */
    public Stream<Long> stream(){
        return value.stream();
    }


    /**
     * 判断是不是空的
     * @return
     */
    public boolean isEmpty(){
        return value.isEmpty();
    }

}
