package com.mini.framework.util.generic.define;

import java.util.Date;
import java.util.Optional;

/**
 * 可能的 set Double
 *
 * @author jayheo*/
//TODO 需要添加junit和javadoc
public class OptionalDate{


    private Date date;

    private static final OptionalDate createEmpty (){
        return new OptionalDate();
    }


    public static OptionalDate of(String dateString){
        long dateLong = Long.parseLong(dateString);
        return of(dateLong);
    }


    public static OptionalDate of(long dateLong){
        return of(new Date(dateLong));
    }


    public static OptionalDate ofNullable(Long dateLong){
        return dateLong==null? createEmpty() :of(dateLong);
    }

    public static OptionalDate ofNullable(String dateString){
        return dateString==null? createEmpty() :of(dateString);
    }

    public static OptionalDate ofNullable(Date date){
        return date==null? createEmpty() :of(date);
    }

    /**
     * 从数据中取出来
     * */
    public static OptionalDate of(Date date){
        OptionalDate optional = new OptionalDate();
        optional.date = date;
        return optional;
    }


    public Optional<Date> out(){
        return Optional.ofNullable(date);
    }

    @Override
    public String toString() {
        return out().toString();
    }
}
