package com.mini.framework.util.generic.define;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 可能的 set Double
 * */
//TODO 需要添加junit和javadoc
public class OptionalSetDouble extends OptionalSet<Double> {


    private static final OptionalSetDouble createEmpty (){
        return new OptionalSetDouble();
    }

    public static OptionalSetDouble ofNullable(Collection<Double> collDouble){
        return collDouble==null? createEmpty()  :of(collDouble);
    }

    /**
     * 从集合中取出来
     * */
    public static OptionalSetDouble of(Collection<Double> collDouble){
        OptionalSetDouble set = new OptionalSetDouble();
        Objects.requireNonNull(collDouble,"collDouble不能为空");
        set.value = new LinkedHashSet<>(collDouble);
        return set;
    }

    public static OptionalSetDouble ofNullable(Double... ts){
        return ts==null? createEmpty() :of(ts);
    }

    /**
     * 从数据中取出来
     * */
    public static OptionalSetDouble of(Double... ts){
        return of(Stream.of(ts).collect(Collectors.toSet()));
    }


    public static OptionalSetDouble ofNullable(String arr){
        return arr==null? createEmpty() :of(arr);
    }

    public static OptionalSetDouble of(String arr){
        String[] Doubles = arr.split(",");
        List<Double> list = Stream.of(arr.split(",")).map(Double::parseDouble).collect(Collectors.toList());
        return of(list);
    }

    public Optional<Set<Double>> out(){
        return out(false);
    }

    public Optional<Set<Double>> outNotZero(){
        return out(true);
    }

    public Optional<Set<Double>> out(boolean zeroAsNull){
        if(zeroAsNull && (value!=null&& value.isEmpty())){
            return Optional.empty();
        }
        return Optional.ofNullable(value);
    }


    @Override
    public String toString() {
        return out().toString();
    }

}
