package com.mini.framework.util.generic.define;

import com.mini.framework.util.asserts.AssertUtil;

import java.util.Optional;
import java.util.function.Consumer;

/**
 * 可能存在的字符串
 * @see Optional#of(Object)
 * @author jayheo
 */
public final class OptionalString {


    private final String value;

    private OptionalString(String value) {
        this.value = value;
    }

    public static OptionalString empty(){
        return new OptionalString(null);
    }

    public static OptionalString of(String value){
        AssertUtil.assertMethodRequire(value,"value");
        return ofNullable(value);
    }
    public static OptionalString ofNullable(String value){
        return new OptionalString(value);
    }

    public OptionalString ifPresent(Consumer<String> consumer){
        out().ifPresent(consumer);
        return this;
    }

    public Optional<String> out(){
        return Optional.ofNullable(value);
    }

}
