package com.mini.framework.util.generic.define;


import com.mini.framework.util.asserts.AssertUtil;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

/**
 * integer的set集合 这种写法是解决泛型带来的部分参数不明确的影响<BR>
 * 等价于<br>
 * @see Set<Integer>
 * @author jayheo
 */
public class SetInt {

    /**
     * 初始值，不可以被修改的。
     */
    private final Set<Integer> value;

    public SetInt(Set<Integer> value) {
        this.value = value;
    }


    public static SetInt of(int... ints){
        return of(IntStream.of(ints).boxed().collect(Collectors.toSet()));
    }

    public static SetInt of(Integer... ints){
        return of(Stream.of(ints).collect(Collectors.toSet()));
    }

    public static SetInt of(Set<Integer> set){
        AssertUtil.assertMethodRequire(set,"set");
        return new SetInt(set);
    }

    public static SetInt of(Collection<Integer> coll){
        return of(new HashSet<>(coll));
    }

    public static <L> SetInt of(Function<L,Integer> intGetter, Collection<L> coll){
        return of(coll.stream()
                .map(intGetter)
                .collect(Collectors.toSet()));
    }

    /**
     * 复制出一个副本
     * @return
     */
    public SetInt copy(){
        return SetInt.of(out());
    }


    /**
     * 输出
     * @return
     */
    public Set<Integer> out(){
        return value;
    }


    /**
     * 返回一个stream
     * @return
     */
    public Stream<Integer> stream(){
        return value.stream();
    }


    /**
     * 判断是不是空的
     * @return
     */
    public boolean isEmpty(){
        return value.isEmpty();
    }


    /**
     * 判断是不是  非空。<BR>
     * 这里注意，对于  [null] 也代表是非空,<BR>
     * 我们的规范中，接受有  这样的数组 [null,""] 也就是list set map 等中不允许用 null，如果业务可能用就应该使用List<Optional<Bean>> 的方式<BR>
     * TODO 这段话要加入代码标准。
     * @return  空返回false 非空返回true
     */
    public boolean isNotEmpty(){
        return !this.isEmpty();
    }

}
