package com.mini.framework.util.http.full;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.Map;
import java.util.Optional;

/**
 * @author jayheo
 */
public class FullHttpResponse {

    private FullHttpRequest request;

    private int status;

    private Map<String,String> headers;

    private String body;

    public FullHttpResponse(FullHttpRequest request,int status, Map<String, String> headers, String body) {
        this.request = request;
        this.status = status;
        this.headers = headers;
        this.body = body;
        headers.put("status", String.valueOf(status));
    }

    public Optional<String> showBody(){
        return Optional.ofNullable(body);
    }

    public FullHttpRequest getRequest() {
        return request;
    }


    public int getStatus() {
        return status;
    }


    public Map<String, String> getHeaders() {
        return headers;
    }


    public String getBody() {
        return body;
    }


    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
