package com.mini.framework.util.mq;

import com.mini.framework.util.thread.HaveCurrSiteable;

/**
 * 系统通知
 * @author jayheo
 *
 * @param <U> 用户id类型
 * @param <T>
 */
public interface SystemNoticeAble<U,T> extends HaveCurrSiteable<T>{
	/**
	 * 通过级别
	 * 
	 * @return
	 */
	int level();

	String msg();
	
	/**
	 * 接受者，也就是用户id
	 * @return
	 */
	U receiver();
	
	
	default String debugMsg(){
		return String.format("%s级消息需要发送给用户:[%s]内容是:[%s]",level(),receiver(),msg());
	}
	
	
	/**
	 * 是不是可以忽略不发消息
	 * @return
	 */
	default public boolean ignore(){
		return false;
	}
}
