package com.mini.framework.util.oss;

import java.util.Optional;
import java.util.function.Function;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.http.SimpleHttpUtil;
import com.mini.framework.util.oss.bean.OssImageProcessParams;
import com.mini.framework.util.oss.bean.PicInfo;
import com.mini.framework.util.oss.bean.StringPicInfo;
import com.mini.framework.util.string.JsonEditUtil;

/**
 * oss图片工具
 * 
 * @author jayheo
 *
 */
public class OssPicUtil {

	
	//TODO 这里要写一个统一拼接参数的公用方法。
	private static Logger logger = LogManager.getLogger(OssPicUtil.class);
	
	/**
	 * 按百分比缩放
	 * @param ossUrl
	 * @param percent
	 * @return
	 */
	public static String resizePercent(String ossUrl, int percent) {
		// TODO 1-100 之间
		String split = ossUrl.contains("?") ? "," : "?";
		String newUrl = String.format("%s%sx-oss-process=image/resize,p_%s", ossUrl, split, percent);
		return newUrl;
	}
	
	
	/**
	 * 变成一个logo样式，指定连长
	 * @param ossUrl
	 * @param size
	 * @return
	 */
	public static String toSizeLogo(String ossUrl,int size){
		String split = ossUrl.contains("?") ? "," : "?";
		String newUrl = String.format("%s%sx-oss-process=image/resize,m_fill,h_%s,w_%s", ossUrl,split, size, size);
		return newUrl;
	}
	
	public static String tryToAverageColer(String ossUrl){
		String split = ossUrl.contains("?") ? "," : "?";
		String newUrl = String.format("%s%sx-oss-process=image/average-hue", ossUrl,split);
		try{
			String resp = SimpleHttpUtil.simpleGet(newUrl);
			String rgb = JsonEditUtil.getJsonMapNamespaceValue(resp, new String[]{"RGB"});
			return rgb;
		}catch(Exception e){
			logger.debug("根据url:{}没有得到平均色",ossUrl);
			return null;
		}
		
	}
	

	public static Optional<PicInfo> tryQueryBaseInfo(String ossUrl){
		try{
			return Optional.ofNullable(findBaseInfo(ossUrl));
		}catch(Exception e){
			logger.debug("从ossUrl:{}解析不出图片尺寸",ossUrl,e);
			return Optional.empty();
		}
	}
	
	
	/**
	 * 使用 tryQueryBaseInfo
	 * 尝试查询图片的基本信息
	 * @param ossUrl
	 * @return
	 */
	@Deprecated //tryQueryBaseInfo
	public static PicInfo tryFindBaseInfo(String ossUrl){
		return tryQueryBaseInfo(ossUrl).orElse(null);
	}
	
	/**
	 * 查询图片的基本信息
	 * @param ossUrl
	 * @return
	 */
	public static PicInfo findBaseInfo(String ossUrl){
		AssertUtil.assertMethodRequire(ossUrl, "ossUrl");
		String split = ossUrl.contains("?") ? "," : "?";
		String newUrl = String.format("%s%sx-oss-process=image/info", ossUrl,split);
		String resp = SimpleHttpUtil.simpleGet(newUrl);
		StringPicInfo stringPicInfo = new StringPicInfo();
		JsonEditUtil.fillStringValue(resp,  stringPicInfo);
		PicInfo picInfo = new PicInfo();
		picInfo.setFileSize(Integer.parseInt(stringPicInfo.getFileSize()));
		picInfo.setHeight(Integer.parseInt(stringPicInfo.getHeight()));
		picInfo.setWidth(Integer.parseInt(stringPicInfo.getWidth()));
		picInfo.setFormat(stringPicInfo.getFormat());
		return picInfo;
	}
	

	/**
	 * 把底部裁剪了按宽度的比较来
	 * @param ossUrl
	 * @param widthRatio
	 * @param ossUrlResave
	 * @return
	 */
	public static String cutBottom(String ossUrl,int widthRatio,Function<String, String> ossUrlResave){
		OssImageProcessParams webpProcess = OssImageProcessParams.formatWebpProcess();
		ossUrl =webpProcess.applyParams(ossUrl);
		if(ossUrl.contains("x-oss-process")){//如果已被处理了防止获取出错要重新获取一下
			ossUrl = ossUrlResave.apply(ossUrl);
		}
		PicInfo picInfo = findBaseInfo(ossUrl);
		int height = picInfo.getHeight();
		int width = picInfo.getWidth();
		int cutHeight = width*widthRatio/100;
		OssImageProcessParams cutProcess =  OssImageProcessParams.crossCutProcess(0 ,height - cutHeight ,width);
		OssImageProcessParams format = OssImageProcessParams.formatProcess("jpg");
		String preResult = OssImageProcessParams.applyMultiParams(ossUrl, cutProcess,format);
		return ossUrlResave.apply(preResult);
	}
	
	
	/**
	 * TODO https://help.aliyun.com/document_detail/47505.html?spm=a2c4g.11186623.2.14.236057f9WdyRzG#concept-agt-jgc-kfb
	 * 这里应该改造成通过java sdk来处理的做法
	 * 追加底部白边，按宽度的比例来计算
	 * @param ossPath
	 * @param widthRatio
	 * @param ossUrlResave 传入的完整url传出的也应该是完整url
	 * @return
	 */
	public static String appendBottomWhite(String ossUrl,int widthRatio,Function<String, String> ossUrlResave){
		ossUrl = OssImageProcessParams.formatWebp(ossUrl);
		if(ossUrl.contains("x-oss-process")){//如果已被处理了防止获取出错要重新获取一下
			ossUrl = ossUrlResave.apply(ossUrl);
		}
		PicInfo picInfo = findBaseInfo(ossUrl);
		int height = picInfo.getHeight();
		int width = picInfo.getWidth();
		//宽度乘以宽度的widthRatio个百分比，
		int appendHeight = width*widthRatio/100;
		//上下都加个空白
		AssertUtil.assertNoBadReq(height + appendHeight*2<=4096,Status.BadReq.illParam, "尺寸:[%s]太大不能超过4096",height + appendHeight*2);
		OssImageProcessParams firstProcess = new OssImageProcessParams("resize","m","pad","color","FFFFFF")
		.param("limit", 0).param("w", width)
		// appendHeight 再乘以2(因为上面下面都要加)
		.param("h", height + appendHeight*2 );
		//把上面的空白切掉
		OssImageProcessParams secondProcess =  OssImageProcessParams.crossCutProcess(appendHeight ,height +appendHeight ,width);
		String bottomWhiteOssUrl = OssImageProcessParams.applyMultiParams(ossUrl,firstProcess,secondProcess);
		String bottomWhiteOssUrlJpg = OssImageProcessParams.formatProcess("jpg").applyParams(bottomWhiteOssUrl);
		String result = ossUrlResave.apply(bottomWhiteOssUrlJpg);
		return result;
	}
	
	
	/**
	 * 向下渐渐虚化
	 * @param ossPath 源资源在oss上的路径
	 * @param width 需要压缩的宽度
	 * @param realPercent 保留真实的比例
	 * @param shadePercent 需要虚化的渐变比例
	 * @param shadeFine 渐变精细度[3,100]越大越精细 
	 * @param ossResave oss重新存储一下
	 * @return
	 */
	public static String downShadeBlur(String ossPath,int width,int realPercent,int shadePercent,int shadeFine,Function<String, String> ossResave){

		//模糊器生成器
		Function<Integer, OssImageProcessParams> blurProcessGetter = (size) -> new OssImageProcessParams("blur","r",size,"s",size);
		//渐变的起点
		int shadeBegin = width *16 * realPercent / (9 * 100);
		//渐变的终点
		int shadeEnd = width *16 * (realPercent+shadePercent) / (9 * 100);
		
		//得到原始的图片，转成绝对尺寸例如 width 得到基础的模板
		OssImageProcessParams baseModelProcess = new OssImageProcessParams("resize","m","lfit").param("w",width);

		//步骤1，得到底板，宽度为width 且虚化了
		String bottomOssPath = OssImageProcessParams.applyMultiParams(ossPath, baseModelProcess,blurProcessGetter.apply(50)
				,baseModelProcess,blurProcessGetter.apply(50)
				,baseModelProcess,blurProcessGetter.apply(50)
				,baseModelProcess,blurProcessGetter.apply(50)
				,baseModelProcess,blurProcessGetter.apply(50)
				);
		
		//步骤2，把实化的图片部分以水印的形式放到底板上
		//得到要实化的图片部分   原图->底板->横向切割
		String realCutOssPath = OssImageProcessParams.applyMultiParams(ossPath,baseModelProcess, OssImageProcessParams.crossCutProcess(0, shadeBegin, width));
		bottomOssPath = OssImageProcessParams.applyMultiParams(bottomOssPath, OssImageProcessParams.crossDownImageWatermarkProcess(realCutOssPath, 0, 0));
		//2，依次把不那么实化的图片分以水印的形式放到底板上，透明度慢增，
		//根据 shadeFine 决定切的次数
		for (int step = 0; step < shadeFine; step++) {
			if(step==10){
 				bottomOssPath = ossResave.apply(bottomOssPath);
			}
			int transparent  = 100*   (step+1)/shadeFine;//透明度一点点增加直到100;
			int cutOffset = shadeBegin + (shadeEnd -  shadeBegin) * (step)/shadeFine;//切割起点= 渐变的起点 +  区间 * 切割步数*总步数
			int cutToset = shadeBegin + (shadeEnd -  shadeBegin) * (step+1)/shadeFine;//切割终点= 渐变的起点 +  区间 * (切割步数+1)*总步数
			int cutLimit = cutToset - cutOffset ;
			String halfCutOssPath = OssImageProcessParams.applyMultiParams(ossPath,baseModelProcess, OssImageProcessParams.crossCutProcess(cutOffset, cutLimit, width));
			bottomOssPath = OssImageProcessParams.applyMultiParams(bottomOssPath,OssImageProcessParams.crossDownImageWatermarkProcess(halfCutOssPath, cutOffset, transparent));
		}
		return ossResave.apply(bottomOssPath);
		
	}
	
}
