package com.mini.framework.util.oss;

import java.util.function.Function;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.http.HttpResStatusUtil;


//https://help.aliyun.com/document_detail/64555.html#h2-url-2
/**
 * oss视频处理
 * @author jayheo
 *
 */
public class OssVideoUtil {

	public static String tryGetCover(String videoUrl,int milliSecond,Function<String, String> resReader){
		AssertUtil.assertMethodRequire(videoUrl, "videoUrl");
		AssertUtil.assertMethodRequire(resReader, "resReader");
		// 这里要判断 封面是不是有效的 先写成这样以后优化
		String cover =String.format("%s%sx-oss-process=video/snapshot,t_%s,f_jpg,m_fast,ar_auto", videoUrl,videoUrl.indexOf("?")>0?"&":"?",milliSecond);
		if(HttpResStatusUtil.isExist(cover)){
			return resReader.apply(cover);
		}else{
			return null;
		}
	}
	
}
