package com.mini.framework.util.oss;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * 用户在打水印时，可以对水印图片进行预处理，支持的预处理操作有：图片缩放，图片裁剪（不支持内切圆)，
 * 图片旋转（具体内容请直接查看文档相关章节）。在“resize”操作下还额外支持一个参数：P（大写P），
 * 表示水印图片按主图的比例进行处理，取值范围为[1, 100]，表示百分比。
 * 不支持内切圆做水印要特别注意，它还不会报错。
 * @author jayheo
 *
 */
public class OssWatermarkReplace implements Comparable<OssWatermarkReplace>{

	/**
	 * 水印64base替换量的起点
	 * 务必注意从//host:port算起，前面的http和https都不要。
	 */
	private int base64Offset;
	/**
	 * 水印64base替换量长度
	 */
	private int base64Length;

	/**
	 * 水印的类型
	 */
	private WatermarkType watermarkType;
	
	
	private String watermarkContent;
	
	/**
	 * 内容的关键key
	 * 用这个来标记他是什么样的内容
	 */
	private String contentKey;
	
	

	public OssWatermarkReplace() {
		super();
	}
	
	public OssWatermarkReplace(int base64Offset, int base64Length,String contentKey,WatermarkType watermarkType,String watermarkContent) {
		super();
		this.base64Offset = base64Offset;
		this.base64Length = base64Length;
		this.contentKey = contentKey;
		this.watermarkType = watermarkType;
		this.watermarkContent = watermarkContent;
	}

	public OssWatermarkReplace(int base64Offset, int base64Length,String contentKey) {
		super();
		this.base64Offset = base64Offset;
		this.base64Length = base64Length;
		this.contentKey = contentKey;
	}
	
	public OssWatermarkReplace(int base64Offset, int base64Length, WatermarkType watermarkType, String watermarkContent) {
		super();
		this.base64Offset = base64Offset;
		this.base64Length = base64Length;
		this.watermarkType = watermarkType;
		this.watermarkContent = watermarkContent;
	}

	public int getBase64Offset() {
		return base64Offset;
	}

	public void setBase64Offset(int base64Offset) {
		this.base64Offset = base64Offset;
	}

	public int getBase64Length() {
		return base64Length;
	}

	public void setBase64Length(int base64Length) {
		this.base64Length = base64Length;
	}

	public WatermarkType getWatermarkType() {
		return watermarkType;
	}

	public void setWatermarkType(WatermarkType watermarkType) {
		this.watermarkType = watermarkType;
	}

	public String getWatermarkContent() {
		return watermarkContent;
	}

	public void setWatermarkContent(String watermarkContent) {
		this.watermarkContent = watermarkContent;
	}
	
	public String getContentKey() {
		return contentKey;
	}

	public void setContentKey(String contentKey) {
		this.contentKey = contentKey;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	@Override
	public int compareTo(OssWatermarkReplace other) {
		return this.base64Offset - other.base64Offset;
	}
	
}
