package com.mini.framework.util.oss.bean.offset;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.lang3.StringUtils;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * 通过网格控制位置的水印
 * @author jayheo
 *
 */
public enum GridOffsetWaterMarkType implements GridOffsetWaterMarkNumber{

	/**
	 * 海报预设位置1
	 */
	postOffset1("海报预设位置1,放在左下方的小程序码",100,85,95,100,85,95),
	postOffset2("海报预设位置2,放在左下方的小程序码",8,7,8,5,4,5);
	
	private String desc;
	
	/**
	 * 宽的size
	 */
	private int ws;
	/**
	 * 宽的起点
	 */
	private int wf;
	
	/**
	 * 宽的结束点
	 */
	private int wt;
	
	
	/**
	 * 高的size
	 */
	private int hs;
	/**
	 * 高的起点
	 */
	private int hf;
	
	/**
	 * 高的结束点
	 */
	private int ht;
	
	private GridOffsetWaterMarkType(String desc,int ws, int wf, int wt, int hs, int hf, int ht) {
		this.desc = desc;
		this.ws = ws;
		this.wf = wf;
		this.wt = wt;
		this.hs = hs;
		this.hf = hf;
		this.ht = ht;
	}
	
	public String getDesc(){
		return desc;
	}

	public int getWs() {
		return ws;
	}

	public int getWf() {
		return wf;
	}

	public int getWt() {
		return wt;
	}

	public int getHs() {
		return hs;
	}

	public int getHf() {
		return hf;
	}

	public int getHt() {
		return ht;
	}
	
	
	
	public static Optional<GridOffsetWaterMarkNumber> parseOffset(String numberOffset){
		AssertUtil.assertMethodRequire(numberOffset, "numberOffset");
		String[] numStrs = numberOffset.split(",");
		for (String num : numStrs) {
			if(!StringUtils.isNumeric(num)){
				return Optional.empty();
			}
		}
		Integer[] nums = Stream.of(numStrs).map(Integer::parseInt).collect(Collectors.toList()).toArray(new Integer[]{});
		if(numStrs.length==4){
			String desc = "通过4个数字定位:" + numberOffset;
			SimpleGridOffsetWaterMarkNumber offset = new SimpleGridOffsetWaterMarkNumber(desc,100, nums[0],nums[1], 100, nums[2],nums[3]);
			return Optional.of(offset);
		} else if(numStrs.length==6){
			String desc = "通过6个数字定位:" + numberOffset;
			SimpleGridOffsetWaterMarkNumber offset = new SimpleGridOffsetWaterMarkNumber(desc, nums[0],nums[1], nums[2],nums[3], nums[4],nums[5]);
			return Optional.of(offset);
		}else{
			return Optional.empty();
		}
	}
	
	@Override
	public String serialize() {
		return String.format("%s,%s,%s,%s,%s,%s", ws,wf,wt,hs,hf,ht);
	}
}
