package com.mini.framework.util.oss.bean.work.mark;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

import com.mini.framework.util.photo.PhotoBodilyFormType;

public interface HaveMarkPhotoFrame {
	default List<PhotoBodilyFormType> showNonNullFrameSchemes() {
		if (showFrameSchemes() == null){
			return new ArrayList<PhotoBodilyFormType>();
		}else{
			return showFrameSchemes().stream().filter(Objects::nonNull).collect(Collectors.toList());
		}
	}

	public List<PhotoBodilyFormType> showFrameSchemes();
	
	
	static Optional<HaveMarkPhotoFrame> mapperClassTypeMatch(Object object){
		if(matchClassType(object)){
			return Optional.of((HaveMarkPhotoFrame)object);
		}else{
			return Optional.empty();
		}
	}
	
	
	static boolean matchClassType(Object object){
		if(object instanceof HaveMarkPhotoFrame){
			return true;
		}else{
			return false;
		}
	}

}
