package com.mini.framework.util.oss.bean.work.modify;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.bean.desc.RoleDesc;
import com.mini.framework.util.oss.bean.OssImageProcessParams;

@Desc("切成圆图，不可以做水印附图")
public class CircleByRadiusOssImageWork extends ModifyOssImageWork{

	/**
	 * 半径
	 */
	@Desc("圆的半径")
	@RoleDesc(required=true)
	private Integer radius;
	
	public CircleByRadiusOssImageWork(Integer radius) {
		super();
		this.radius = radius;
	}

	public Integer getRadius() {
		return radius;
	}

	public void setRadius(Integer radius) {
		this.radius = radius;
	}

	public CircleByRadiusOssImageWork() {
	}



	@Override
	public OssImageProcessParams mapperProcessParams(Function<String, String> sureSameBucket) {
		return OssImageProcessParams.circleByRadius(radius);
	}
	
	public static List<CircleByRadiusOssImageWork> createExamples() {
		CircleByRadiusOssImageWork example = new CircleByRadiusOssImageWork();
		example.setWorkDesc("切成圆图，不可以做水印附图");
		List<CircleByRadiusOssImageWork> examples = new ArrayList<>();
		examples.add(example);
		return examples ;
	}

}
