package com.mini.framework.util.page;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;

/**
 * 分段工具类
 * 如果一个线程中出现多个查询操作，
 * 那么只会在第一次查询时生效，如果发现不生效的情况可以检查这里。
 * @author jayheo
 *
 */
public class SectionUtil {
	
	
	/**
	 * <pre>
	 * 通过线程分页这里依赖分布插件
	 * 如果分页无效，检查一下是否注入了分页插件
	 * 		@Bean
	 *      public PageHelper buildPageInterceptor() {
	 * 		PageHelper pageInterceptor = new PageHelper();
	 * 		Properties properties = new Properties();
	 * 		properties.setProperty("offsetAsPageNum", "false");
	 * 		properties.setProperty("rowBoundsWithCount", "false");
	 * 		properties.setProperty("reasonable", "false");
	 * 		properties.setProperty("dialect", "mysql");
	 * 		pageInterceptor.setProperties(properties);
	 * 		return pageInterceptor;
	 *    }
	 * 数据源设置插件
	 * PageHelper  pageInterceptor = buildPageInterceptor();
	 * 		Interceptor[] plugins = new Interceptor[] { pageInterceptor  };
	 * 		//设置插件
	 *         factoryBean.setPlugins(plugins);
	 * </pre>
	 * @param sectionInfo
	 * @param force 要不要检查分页参数。
	 */
	public static void threadSection(Section sectionInfo,boolean force){
		if(completeSection(sectionInfo)){
			PageHelper.offsetPage(sectionInfo.getOffset(),sectionInfo.getLimit(),sectionInfo.requireCount());
		}else{
			AssertUtil.assertNoBadReq(!force, Status.BadReq.noReq, "必须有正确的分页参数offset和limit, bean section:%s",sectionInfo);
		}
	}

	/**
	 * <pre>
	 * 检查分页参数
	 * </pre>
	 * @param sectionInfo
	 */
	public static void valiSection(Section sectionInfo){
		AssertUtil.assertNoBadReq(completeSection(sectionInfo), Status.BadReq.noReq, "必须有正确的分页参数offset和limit, bean section:%s",sectionInfo);
	}
	
	public static boolean completeSection(Section sectionInfo){
		return sectionInfo!=null&&sectionInfo.requireParamsComplete();
	}
	
	/**
	 * <pre>
	 * 通过线程分页这里依赖分布插件
	 * 如果分页无效，检查一下是否注入了分页插件
	 * 	 * 		@Bean
	 * 	 *      public PageHelper buildPageInterceptor() {
	 * 	 * 		PageHelper pageInterceptor = new PageHelper();
	 * 	 * 		Properties properties = new Properties();
	 * 	 * 		properties.setProperty("offsetAsPageNum", "false");
	 * 	 * 		properties.setProperty("rowBoundsWithCount", "false");
	 * 	 * 		properties.setProperty("reasonable", "false");
	 * 	 * 		properties.setProperty("dialect", "mysql");
	 * 	 * 		pageInterceptor.setProperties(properties);
	 * 	 * 		return pageInterceptor;
	 * 	 *    }
	 * 	 * 数据源设置插件
	 * 	 * PageHelper  pageInterceptor = buildPageInterceptor();
	 * 	 * 		Interceptor[] plugins = new Interceptor[] { pageInterceptor  };
	 * 	 * 		//设置插件
	 * 	 *         factoryBean.setPlugins(plugins);
	 * </pre>
	 * @param sectionInfo
	 */
	public static void threadSection(Section sectionInfo){
		threadSection(sectionInfo, true);
	}
	
	/**
	 * <pre>
	 * 直接取前limit个，也不要分页了
	 * </pre>
	 * @param limit
	 */
	public static void threadSectionLimit(int limit){
		threadSection(new Section(0	, limit, Integer.MAX_VALUE));
	}
	
	/**
	 * <pre>
	 * 把数据映射成map
	 * </pre>
	 * @param list
	 * @return
	 */
	public static <T> Map<String, Object> quickMapList(List<T> list){
		Map<String, Object> resp = new LinkedHashMap<>();
		if(list instanceof Page){
			Page<?> page = (Page<?>)list;
			long count = page.getTotal();
			if(count <0){
				resp.put("ignoreCount", true);
			}else{
				resp.put("count", count);
			}
		}else{
			//这样说明没有分页
			resp.put("noPage", true);
		}
		resp.put("list", list);
		return resp;
	}
	
	/**
	 * <pre>
	 * 内存分段，再转给map，依赖分页插件
	 * </pre>
	 * @param list 这个list会被操作上面传入要谨慎
	 * @param section
	 * @return
	 */
	public  static <T> Map<String, Object> memorySectionMap(List<T> list ,Section section){
		Map<String, Object> map = quickMapList(memorySectionPage(list, section));
		map.put("count", map.get("total"));
		return map;
	}
	
	/**
	 * <pre>
	 * 把第一个集合中的元素添加到第二个集合中
	 * </pre>
	 * @param list
	 * @param page
	 */
	public  static <I,T> void fillElementsToPage(List<I> list ,List<T> page){
		//TODO 当有分页参数的list 使用后 待完善
		/*AssertUtil.assertMethodRequire(page, "page");
		AssertUtil.assertMethodRequire(list, "list");
		page.clear();
		page.addAll(list);*/
	}

	/**
	 * <pre>
	 * 生成一个空的页面
	 * </pre>
	 * @return
	 */
	public  static <T> List<T> createEmptyPage(){
		Page<T> page = new Page<T>();
		page.setTotal(0);
		return page;
	}

	/**
	 * <pre>
	 * 内存分页这里依赖分页插件
	 * 如果分页无效，检查一下是否注入了分页插件
	 * 	 * 		@Bean
	 * 	 *      public PageHelper buildPageInterceptor() {
	 * 	 * 		PageHelper pageInterceptor = new PageHelper();
	 * 	 * 		Properties properties = new Properties();
	 * 	 * 		properties.setProperty("offsetAsPageNum", "false");
	 * 	 * 		properties.setProperty("rowBoundsWithCount", "false");
	 * 	 * 		properties.setProperty("reasonable", "false");
	 * 	 * 		properties.setProperty("dialect", "mysql");
	 * 	 * 		pageInterceptor.setProperties(properties);
	 * 	 * 		return pageInterceptor;
	 * 	 *    }
	 * 	 * 数据源设置插件
	 * 	 * PageHelper  pageInterceptor = buildPageInterceptor();
	 * 	 * 		Interceptor[] plugins = new Interceptor[] { pageInterceptor  };
	 * 	 * 		//设置插件
	 * 	 *         factoryBean.setPlugins(plugins);
	 * </pre>
	 * @param list
	 * @param section
	 * @param <T>
	 * @return
	 */
	public  static <T> Page<T> memorySectionPage(List<T> list ,Section section){
		AssertUtil.assertMethodRequire(section, "section");
		AssertUtil.assertMethodRequire(list, "list");
		valiSection(section);
		Page<T> page = new Page<T>();
		page.setTotal(list.size());
		page.setStartRow(section.getOffset());
		retainSection(list, section);
		page.addAll( list);
		return page;
	}
	
	
	/**
	 * <pre>
	 * 保留前面几个
	 * </pre>
	 * @param list
	 * @param limit
	 */
	public static <T> List<T> retainLimit(List<T> list,int limit){
		return retainSection(list, new Section(0,limit));
	}
	
	/**
	 * <pre>
	 * 保留某一段，传入的list会被修改了，这里依赖分页插件
	 * </pre>
	 * @param list
	 * @param section
	 * @return
	 */
	public static <T> List<T> retainSection(List<T> list,Section section){
		//去掉头部。
		list.subList(0, Math.min(section.getOffset(),list.size())).clear();
		if(list.size()>section.getLimit()){
			//去掉尾部
			list.subList(section.getLimit(),list.size()).clear();
		}
		return list;
	}


	/**
	 * 从list中得到page对象
	 * @param list
	 * @param <T>
	 * @return
	 */
	public static  <T> Optional<Page<?>> findPageFromList(List<T> list){
		if(list instanceof Page){
			return Optional.of((Page)list);
		}else{
			return Optional.empty();
		}
	}
	
}
