package com.mini.framework.util.photo;

import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;
import java.util.stream.Stream;

import com.mini.framework.util.bean.VarUtil;
import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.type.EnumTypeShower;

@Desc("高瘦/正方/矮胖类型，对于不同的图片粗略分类成三种")
public enum PhotoBodilyFormType  implements EnumTypeShower<PhotoBodilyFormType>{
	

	@Desc("高度比宽度大的")
	height(1.33,GoldRatio.witdh,2.0,"高瘦型","高度比宽度大的"),

	@Desc("高度比宽度差不多大的")
	square(0.8,1.0,1.25,"正方型","高度比宽度差不多大的"),

	@Desc("高度比宽度小的")
	width(0.57,GoldRatio.height,0.67,"矮胖型","高度比宽度小的"),
	
	@Desc("高度比宽度小很多的")
	flat(0.4,0.5,0.5625,"扁形的","高度比宽度小很多的"),
	;
	
	/**
	 * 最小的高宽比
	 */
	private Double minRatio;
	
	/**
	 * 合适的高宽比，一般会使用黄金分割点
	 */
	private Double perfectRatio;

	/**
	 * 最大的高宽比
	 */
	private Double maxRatio;
	
	private String title;

	private String desc;
	

	public String title() {
		return title;
	}

	public String desc() {
		return desc;
	}
	
	private PhotoBodilyFormType(Double minRatio,Double perfectRatio, Double maxRatio, String title, String desc) {
		this.minRatio = minRatio;
		this.perfectRatio = perfectRatio;
		this.maxRatio = maxRatio;
		this.title = title;
		this.desc = desc;
	}
	
	public boolean matchRatioScope(double ratio){
		return minRatio<=ratio && maxRatio>=ratio;
	}
	
	public static Optional<PhotoBodilyFormType> findByRatioScope(int width,int height){
		return findByRatioScope(countRatio(height, width));
	}
	
	public static Optional<PhotoBodilyFormType> findByRatioScope(double ratio){
		return Stream.of(values()).filter(type->type.matchRatioScope(ratio)).findFirst();
	}
	
	private static double countRatio(int height,int width){
		//TODO 不允许少于0
		return 1.0*height/width;
	}
	
	public static Entry<Integer, Integer> cutSizeByRatio(double suitableRatio,int width,int height){
		double ratio = countRatio(height,width);
		if(suitableRatio > ratio){//把高变小
			width =(int)(height/ suitableRatio );
		}else{//把宽变小
			height = (int)( suitableRatio * width);
		}
		return VarUtil.createEntry(width, height);
	}
	
	public Entry<Integer, Integer> cutPerfectSize(int width,int height){
		return cutSizeByRatio(perfectRatio, width, height);
	}
	
	
	public Entry<Integer, Integer> cutSuitableSize(int width,int height){
		double ratio = countRatio(width, height);
		if(ratio>maxRatio){
			return cutSizeByRatio(maxRatio, width, height);
		}else if(ratio<minRatio){
			return cutSizeByRatio(minRatio, width, height);
		}else{
			return VarUtil.createEntry(width, height);
		}
	}

	@Override
	public void fillFieldToMap(Map<String, Object> map) {
		map.put("title", title);
		map.put("maxRatio", maxRatio);
		map.put("minRatio", minRatio);
		map.put("perfectRatio", perfectRatio);
		map.put("desc", desc);
	}

}
