package com.mini.framework.util.relation;

import java.util.List;


/** 
* @ClassName: Cascadable 
* @Description: 可以级联的 
* @author jayheo
* @date 2017年3月26日 下午11:31:03 
* 
* @param <N> 实现类型 
*/
public interface Cascadable<N> {
	
	
	/** 
	* @Title: getSuperNode 
	* @Description: 返回父节点的key
	* @param @return     父节点的key
	* @return K    返回类型 
	* @author jayheo
	* @throws 
	*/
	public String showSuperNodeKey();
	/** 
	* @Title: getNode 
	* @Description: 返回本节点key
	* @param @return     本节点key
	* @return K    返回类型 
	* @author jayheo
	* @throws 
	*/
	public String showNodeKey();
	/**
	 * 添加子节点
	 * @param node
	 */
	public void addSonNode(N node);
	
	/** 
	 * @Title: getSubNodes 
	 * @Description: 返回子结点列表
	 * @param @return    子结点列表
	 * @return List<Cascadable<K>>    返回类型 
	 * @author jayheo
	 * @throws 
	 */
	public List<N> showSonNodes();
	
}