package com.mini.framework.util.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 树链游标
 * 要遍历一个树，把树上所有的东西。
 * @author jayheo
 *
 * @param <T> 实现 了级联的节点
 */
public interface LinkTreeCursor<T> {

	/**
	 * 游标扫描树上的一个节点
	 * @param cascadable
	 */
	void scan(Cascadable<T> cascadable);

	/**
	 * 需要下一个游标，如果没有请创建
	 * @return
	 */
	LinkTreeCursor<T> moreCursor();
	/**
	 * 把下一个游标弹出来。如果没有返回空
	 * @return
	 */
	LinkTreeCursor<T> popMoreCursor();
	
	
	/**
	 * 汇总
	 * @param subTreeLinkCursor
	 */
	void forSummary(LinkTreeCursor<T> subTreeLinkCursor);
	
	
	
	
	/**
	 * 用一个游标扫描级联树状节点。
	 * @param linkTreeCursor 游标
	 * @param cascadables 级联树 
	 */
	public static <T> void scanTree(LinkTreeCursor<T> linkTreeCursor,Collection<? extends Cascadable<T>> cascadables){
		for (Cascadable<T> cascadable : cascadables) {
			List<?> subCascadables = cascadable.showSonNodes();
			if(subCascadables!=null&&subCascadables.size()>0){
				LinkTreeCursor<T> subLinkTreeCursor = linkTreeCursor.moreCursor();
				scanTree(subLinkTreeCursor, (Collection<? extends Cascadable<T>>) subCascadables);
				//最后所在一下统计，如果需要的话
				linkTreeCursor.forSummary(subLinkTreeCursor);
			}
			//递归扫描每个节点。
			linkTreeCursor.scan(cascadable);
		}
	}
	
	
	/**
	 * 把link指针变成list
	 * @param corsorTree
	 * @return
	 */
	public static <T> List<LinkTreeCursor<T>> toList(LinkTreeCursor<T> corsorTree){
		List<LinkTreeCursor<T>> corsors = new ArrayList<LinkTreeCursor<T>>();
		corsors.add(corsorTree);
		LinkTreeCursor<T> currCorsor = corsorTree;
		LinkTreeCursor<T> next = null;
		while((next  = currCorsor.popMoreCursor())!=null){
			corsors.add(next);
			currCorsor = next;
		}
		return corsors ;
	}
	
}
