package com.mini.framework.util.report.statistics.exception;

import org.springframework.dao.DuplicateKeyException;

import java.util.Optional;

/**
 * 持久层的 唯一键key冲突的异常
 */
public class DuplicateUniqueKeyPersistentException extends RuntimeException {

    /**
     * 冲突的唯一key
     */
    private String uniqueKey;

    private String uniqueKeyField;


    /**
     * 把唯一约束的异常转成这个异常
     * @param cause
     * @param message
     */
    public DuplicateUniqueKeyPersistentException(Throwable cause, String message,Object... params) {
        super(String.format(message, params),cause);
    }


    /**
     * 从一个字符串到 得唯一约束的key
     * @param messageOptional
     * @return
     */
    private DuplicateUniqueKeyPersistentException fillStringFromJdbc4Exception(Optional<String> messageOptional){
        String split = "' for key '";
        //"Duplicate entry 'userOrder-d41d8cd98f00b204e9800998ecf8427e-day-2020-01-17 00:00:' for key 'record_key_1'"
        findStringBetween(messageOptional,"Duplicate entry '","'")
                .map(input->input.split(split))
                .filter(items->items.length==2)
                .ifPresent(items->{
                    uniqueKey = items[0];
                    uniqueKeyField = items[1];
        });
        return this;
    }

    private static Optional<String> findStringBetween(Optional<String> inputOptional,String prefix,String suffix){
        return inputOptional
                .filter(input->input.startsWith(prefix))
                .filter(input->input.endsWith(suffix))
                .map(input-> input.substring(prefix.length(),input.length() - suffix.length()));
    }

    /**
     * 从spring 的异常中拿到唯一约束key
     * @return
     */
    public DuplicateUniqueKeyPersistentException fillStringExceptionDuplicateKey(DuplicateKeyException springException){
        Optional.ofNullable(springException.getCause()).ifPresent(jdbcExceptionInstance->{
            String className = jdbcExceptionInstance.getClass().getName();
            switch (className){
                case "com.mysql.jdbc.exceptions.jdbc4.MySQLIntegrityConstraintViolationException":
                    fillStringFromJdbc4Exception(Optional.ofNullable(jdbcExceptionInstance.getMessage()));
                default:
            }
        });
        return this;
    }

    public String getUniqueKey() {
        return uniqueKey;
    }

    public void setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public String getUniqueKeyField() {
        return uniqueKeyField;
    }

    public void setUniqueKeyField(String uniqueKeyField) {
        this.uniqueKeyField = uniqueKeyField;
    }
}
