package com.mini.framework.util.report.statistics.protocol;

import com.mini.framework.util.params.MapParams;
import org.apache.commons.codec.digest.DigestUtils;

/**
 * 统计之可以序列化的条件<p>
 * 要求实现一个方法，保证他是唯一的。
 * #标准名词说明@unique:唯一的不重复的;
 * #标准名词说明@serialize:序列化即变成字符串;
 * @see #uniqueSerialize()
 * @author jayheo
 */
public interface StatisticsSerializeParams {

    /**
     * 不重复的序列化 <br>
     * 即 对于完全相同的值多次序列化结果完全一样。<br>
     * 不完全相同的参数值得到的结果一定不一样。<br>
     * @return
     */
    default String uniqueSerialize(){
        //TODO 目前使用url序列化，方便查看也比较短，但是如果出来非常基本数据类似的参数可能有问题，所以以后要换成有序的json形式。
        return MapParams.build().paramsFromBean(this).toSortedUrlParams();
    }

    default String uniqueSerializeMd5(){
        return DigestUtils.md5Hex(uniqueSerialize());
    }

}
