package com.mini.framework.util.report.statistics.ranking.bean;

import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;

/**
 *  抽象 的 简单的 计数求和 排行元素
 */
public class SimpleSumThenCountRankingElement extends SimpleCountAndSumRankingElement<SimpleSumThenCountRankingElement> {

    @Override
    public double countSorterScore() {
        //TODO 优先sum再count
        return (1.0*getSum()) * Integer.MAX_VALUE + getCount();
    }


    public SimpleSumThenCountRankingElement() {}

    @Override
    protected StatisticsRankingTable<SimpleSumThenCountRankingElement> deserializeJsonRankingTable(String paramsJson) {

        Type type = new TypeToken<StatisticsRankingTable<SimpleSumThenCountRankingElement>>() {
        }.getType();
        return createGsonBuilder().create().fromJson(paramsJson,type);
    }

    public SimpleSumThenCountRankingElement(String countKey, Long count, Long sum) {
        super(countKey,count,sum);
    }
}
