package com.mini.framework.util.report.statistics.ranking.bean;


import com.google.gson.Gson;
import com.mini.framework.util.report.statistics.protocol.OneStatisticsResult;
import com.mini.framework.util.report.statistics.protocol.StatisticsResultMeta;
import com.mini.framework.util.report.statistics.protocol.process.ForkQueryProcess;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Stream;

/**
 * TODO 后续要使用这个代替
 * 统计的地排行榜
 */
public class StatisticsRankingTable<E extends RankingElementSummationAmount<E>> implements OneStatisticsResult {



    private StatisticsResultMeta resultMeta;

    private ForkQueryProcess process;
    
    /**
     * 排行榜的成员数量
     */
    private Integer size;

    /**
     * 具体的元素
     */
    private List<E> elements;

    public static <T extends RankingElementSummationAmount<T>> StatisticsRankingTable<T> create(List<T> elements) {
        StatisticsRankingTable<T> instance = new StatisticsRankingTable<>();
        instance.elements = elements;
        instance.sureRightSize();
        return instance;
    }

    public Optional<E> findSameElementByElement(E other){
        return findSameElementByKey(other.getCountKey());
    }
    public Optional<E> findSameElementByKey(String countKey){
        return elements.stream().filter(element->element.matchKey(countKey)).findFirst();
    }


    public void accumulateOtherElement(Function<String,E> instanceSupplier,E other){
        Optional<E> existOptional = findSameElementByElement(other);
        existOptional.ifPresent(element->element.mergeOtherHandleImplElement(other));
        if(!existOptional.isPresent()){
            elements.add(RankingElementSummationAmount.copyNewInstance(instanceSupplier,other));
        }
        sureRightSize();
        sorterDesc();
    }

    /**
     * 收敛叠加器
     * @param instanceSupplier
     * @param <A>
     * @return
     */
    public static <A extends RankingElementSummationAmount<A>> BinaryOperator<StatisticsRankingTable<A>> reduceAccumulator(Function<String,A> instanceSupplier){
        return (ranking1,ranking2)->accumulateRankings(instanceSupplier,ranking1,ranking2);
    }


    public static <A extends RankingElementSummationAmount<A>> StatisticsRankingTable<A> accumulateRankings(
            Function<String,A> instanceSupplier
            ,StatisticsRankingTable<A> ranking1, StatisticsRankingTable<A> ranking2) {
        StatisticsRankingTable<A> ranking = createEmpty();
        Stream.of(ranking1,ranking2)
                .flatMap(StatisticsRankingTable::stream)
                .forEach(element->ranking.accumulateOtherElement(instanceSupplier,element));
        ranking.mergeOtherResultMeta(ranking1);
        ranking.mergeOtherResultMeta(ranking2);
        return ranking;
    }

    public StatisticsRankingTable<E> retainLimitHead(Optional<Integer> headOptional){
        headOptional.ifPresent(head->retainLimitHead(head));
        return this;
    }


    public StatisticsRankingTable<E> sureRightSize(){
        size = elements.size();
        return this;
    }


    public StatisticsRankingTable<E> retainLimitHead( int head){
        Iterator<E> it = elements.iterator();

        int index = 0;

        while (it.hasNext() && index++<head){
            it.next();
        }
        while (it.hasNext()){
            it.next();
            it.remove();
        }
        return sureRightSize();
    }


    @Override
    public Optional<StatisticsResultMeta> showResultMeta() {
        return Optional.ofNullable(resultMeta);
    }

    @Override
    public void fillResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }


    public static <E extends RankingElementSummationAmount<E>> StatisticsRankingTable<E> createEmpty() {
        return create(new ArrayList<E>());
    }

    public static <A extends RankingElementSummationAmount<A>> StatisticsRankingTable<A> deserialize(String serializeString, A bean) {
        //Gson gson = RankingElementSummationAmount.createGsonBean(bean);
        //StatisticsRankingTable<A> ranking = gson.fromJson(serializeString,new TypeToken<StatisticsRankingTable<A>>(){}.getType());
        //return ranking;
        return bean.deserializeJsonRankingTable(serializeString);

    }

    public <A extends RankingElementSummationAmount<A>> String serialize(A bean) {

        return RankingElementSummationAmount.createGsonBean(bean).toJson(this);
    }

    public Stream<E> stream(){
        return elements.stream();
    }

    /**
     * 要考虑并发，要考虑扩展
     * @return
     */
    public static Gson createGsonBean(RankingElementSummationAmount<?> amount){
        return amount.createGsonBuilder().create();
    }


    public String serializeJson(RankingElementSummationAmount<E> amount){
        return amount.createGsonBuilder().create().toJson(this);
    }

    public static StatisticsRankingTable deserializeJson(RankingElementSummationAmount<?> bean, String json){
        return createGsonBean(bean).fromJson(json, StatisticsRankingTable.class);
    }

    public StatisticsResultMeta getResultMeta() {
        return resultMeta;
    }

    public void setResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    public ForkQueryProcess getProcess() {
        return process;
    }

    public void setProcess(ForkQueryProcess process) {
        this.process = process;
    }

    @Override
    public void clearRedundancyFields() {
        if(elements!=null){
            elements.forEach(OneStatisticsResult::clearRedundancyFields);
        }
    }

    @Override
    public Optional<ForkQueryProcess> showQueryProcess() {
        return Optional.ofNullable(process);
    }

    @Override
    public void fillQueryProcess(ForkQueryProcess process) {
        this.process = process;
    }

    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public List<E> getElements() {
        return elements;
    }

    public void setElements(List<E> elements) {
        this.elements = elements;
    }

    public void sorterDesc() {
        elements.sort(RankingElementSummationAmount.rankingSorterDesc());
    }



}
