package com.mini.framework.util.report.statistics.summation.bean;


import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.report.statistics.protocol.StatisticsSerializeParams;
import com.mini.framework.util.report.statistics.protocol.TimeRegionRange;
import com.mini.framework.util.report.statistics.protocol.TimeRegionUnit;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.Date;
import java.util.function.Function;

/**
 * 求和的元素的值
 * @author jayheo
 */
public class NativeRegionSummationElementAmount extends SummationElementAmount {


    /**
     * 参数序列化的字符串
     */
    private String paramsSerialize;

    /**
     * 参数序列化的字符串 的md5值<BR>
     * 使用md5是降低数据库索引的压力
     */
    private String paramsSerializeMd5;

    /**
     * 时间区域的起点。
     */
    private Date regionOffset;

    /**
     * 统计的时间单元
     */
    private TimeRegionUnit regionUnit;


    /**
     * 区域的联合key，它能代表某个区域。<br>
     * 这个参数用于做时间 的联合条件。方便批量查询
     * @see #regionUnit
     * @see #regionOffset
     */
    private String regionUnionKey;


    private NativeRegionTimeOutNames timeOutNames;


    public NativeRegionSummationElementAmount copy() {
        NativeRegionSummationElementAmount copy = new NativeRegionSummationElementAmount();
        copyToOther(copy);
        copy.paramsSerializeMd5 = paramsSerializeMd5;
        copy.paramsSerialize = paramsSerialize;
        copy.regionUnionKey = regionUnionKey;
        copy.regionUnit = regionUnit;
        copy.regionOffset = regionOffset;
        copy.timeOutNames = timeOutNames;
        return copy;
    }

    @Override
    public void clearRedundancyFields() {
        super.clearRedundancyFields();
        paramsSerialize = null;
        paramsSerializeMd5 = null;
        regionOffset = null;
        regionUnit = null;
        regionUnionKey = null;
    }

    /**
     * 填充 输出名字
     * @param namesMapper
     * @return
     */
    public NativeRegionSummationElementAmount fillOutNames(Function<Date,NativeRegionTimeOutNames> namesMapper){
        this.timeOutNames = namesMapper.apply(regionOffset);
        return this;
    }


    public static String showRegionAndParamsMd5UnionKey(String regionUnionKey,String paramsSerializeMd5){
        return String.format("%s--%s", regionUnionKey,paramsSerializeMd5);
    }
    
    public static String showRegionAndParamsMd5UnionKey(TimeRegionRange region,StatisticsSerializeParams params){
        return showRegionAndParamsMd5UnionKey(region.unitOffsetUnionString(),params.uniqueSerializeMd5());
    }


    public String showRegionAndParamsMd5UnionKey(){
        return showRegionAndParamsMd5UnionKey(regionUnionKey,paramsSerializeMd5);
    }

    public static NativeRegionSummationElementAmount create(StatisticsSerializeParams params, TimeRegionRange requireRange, SummationElementAmount summationAmount) {
        return create(params.uniqueSerialize(),params.uniqueSerializeMd5(),requireRange,summationAmount);
    }
    public static NativeRegionSummationElementAmount create(String paramsSerialize,String paramsSerializeMd5, TimeRegionRange requireRange, SummationElementAmount summationAmount) {
        NativeRegionSummationElementAmount instance = new NativeRegionSummationElementAmount();
        instance.paramsSerialize = paramsSerialize;
        instance.paramsSerializeMd5 = paramsSerializeMd5;
        instance.regionOffset = requireRange.getOffset();
        instance.regionUnit = requireRange.getUnit();
        instance.regionUnionKey = requireRange.unitOffsetUnionString();

        instance.setResultMeta(summationAmount.getResultMeta());
        instance.setCount(summationAmount.count);
        instance.setSum(summationAmount.sum);
        instance.setMax(summationAmount.max);
        instance.setMin(summationAmount.min);
        return instance;
    }
    
    public boolean matchParamsMd5(StatisticsSerializeParams params){
        return matchParamsMd5(params.uniqueSerializeMd5());
    }



    public boolean matchParamsMd5(String paramsSerializeMd5){
        return this.paramsSerializeMd5.equals(paramsSerializeMd5);
    }



    public boolean matchRegionUnionKey(TimeRegionRange regionRange){
        AssertUtil.assertMethodRequire(regionRange,"regionRange");
        return matchRegionUnionKey(regionRange.unitOffsetUnionString());
    }

    public boolean matchRegionUnionKey(String regionUnionKey){
        AssertUtil.assertMethodRequire(regionUnionKey,"regionUnionKey");
        return regionUnionKey.equals(this.regionUnionKey);
    }


    public TimeRegionRange mapperRegionRange(){
        return TimeRegionRange.create(regionUnit,regionOffset);
    }

    public String getParamsSerialize() {
        return paramsSerialize;
    }

    public void setParamsSerialize(String paramsSerialize) {
        this.paramsSerialize = paramsSerialize;
    }

    public String getParamsSerializeMd5() {
        return paramsSerializeMd5;
    }

    public void setParamsSerializeMd5(String paramsSerializeMd5) {
        this.paramsSerializeMd5 = paramsSerializeMd5;
    }

    public Date getRegionOffset() {
        return regionOffset;
    }

    public void setRegionOffset(Date regionOffset) {
        this.regionOffset = regionOffset;
    }

    public TimeRegionUnit getRegionUnit() {
        return regionUnit;
    }

    public void setRegionUnit(TimeRegionUnit regionUnit) {
        this.regionUnit = regionUnit;
    }

    public String getRegionUnionKey() {
        return regionUnionKey;
    }

    public void setRegionUnionKey(String regionUnionKey) {
        this.regionUnionKey = regionUnionKey;
    }

    public NativeRegionTimeOutNames getTimeOutNames() {
        return timeOutNames;
    }

    public void setTimeOutNames(NativeRegionTimeOutNames timeOutNames) {
        this.timeOutNames = timeOutNames;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
