package com.mini.framework.util.report.statistics.summation.bean.compare;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.report.statistics.protocol.DivideDenominatorNumeratorSummation;
import com.mini.framework.util.report.statistics.protocol.OneStatisticsResult;
import com.mini.framework.util.report.statistics.protocol.StatisticsResultMeta;
import com.mini.framework.util.report.statistics.protocol.process.ForkQueryProcess;
import com.mini.framework.util.report.statistics.summation.bean.NativeRegionSummationElementAmount;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * 环比同比的统计对比结果
 * @author jayheo
 */
public class BothSameRoundSummationCompare implements OneStatisticsResult, DivideDenominatorNumeratorSummation<BothSameRoundSummationCompare> {


    private StatisticsResultMeta resultMeta;

    private ForkQueryProcess process;

    /**
     * 主数据
     */
    private NativeRegionSummationElementAmount main;

    /**
     * 环比用手对象
     */
    private NativeRegionSummationElementAmount roundContrast;

    /**
     * 同比用手对象
     */
    private NativeRegionSummationElementAmount sameContrast;


    /**
     * 环比
     */
    private BothSummationCompare roundCompare;


    /**
     * 同比
     */
    private BothSummationCompare sameCompare;


    public static BothSameRoundSummationCompare create(NativeRegionSummationElementAmount main, NativeRegionSummationElementAmount roundContrast, Optional<NativeRegionSummationElementAmount> sameContrastOptional) {
        BothSameRoundSummationCompare instance = new BothSameRoundSummationCompare();
        instance.main = main;
        instance.roundContrast = roundContrast;
        sameContrastOptional.ifPresent(instance::setSameContrast);
        instance.fillRoundSameCompareIfProvide();
        return instance;
    }

    /**
     * 除以另外一个数
     * @param expand
     * @param numeratorSum
     * @param denominatorSum
     * @param other
     */
    @Override
    public void mapperAmountDivideByOther(long expand, boolean numeratorSum, boolean denominatorSum, BothSameRoundSummationCompare other){

        this.mergeOtherResultMeta(other);
        main.mapperAmountDivideByOther(expand,numeratorSum,denominatorSum,other.main);
        roundCompare = null;
        sameCompare = null;
        if(roundContrast!=null && other.roundContrast!=null){
            roundContrast.mapperAmountDivideByOther(expand,numeratorSum,denominatorSum,other.roundContrast);
        }
        if(sameContrast!=null && other.sameContrast!=null){
            sameContrast.mapperAmountDivideByOther(expand,numeratorSum,denominatorSum,other.sameContrast);
        }
        // 由于做了对比 main中 count 有可能为空了。所以不再做计算。
        if(main.haveAmount()){
            fillRoundSameCompareIfProvide();
        }

    }


    /**
     * 填充同比和琵，如果提供了数据就填，如果没有就不填
     * @return
     */
    public BothSameRoundSummationCompare fillRoundSameCompareIfProvide(){
        if(sameContrast != null && sameContrast.haveAmount()){
            fillSameCompare();
        }

        if(roundContrast != null && roundContrast.haveAmount() ){
            fillRoundCompare();
        }
        return this;

    }


    /**
     * 填充同比
     * @return
     */
    public BothSameRoundSummationCompare fillSameCompare(){
        AssertUtil.assertNotFatal(sameContrast!=null,"sameContrast为空时不能使用fillSameCompare()");
        sameCompare = BothSummationCompare.createSummationInstance(main,sameContrast);
        return this;
    }

    /**
     * 填充环比
     * @return
     */
    public BothSameRoundSummationCompare fillRoundCompare(){
        AssertUtil.assertNotFatal(roundContrast!=null,"roundContrast为空时不能使用fillRoundCompare()");
        roundCompare = BothSummationCompare.createSummationInstance(main,roundContrast);
        return this;
    }


    @Override
    public Optional<StatisticsResultMeta> showResultMeta() {
        return Optional.ofNullable(resultMeta);
    }

    @Override
    public void fillResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }


    @Override
    public void clearRedundancyFields() {
        Stream.of(main,roundContrast,sameContrast,roundCompare,sameCompare).filter(Objects::nonNull)
                .forEach(OneStatisticsResult::clearRedundancyFields);
    }

    @Override
    public Optional<ForkQueryProcess> showQueryProcess() {
        return Optional.ofNullable(process);
    }

    @Override
    public void fillQueryProcess(ForkQueryProcess process) {
        this.process = process;
    }



    public NativeRegionSummationElementAmount getMain() {
        return main;
    }

    public void setMain(NativeRegionSummationElementAmount main) {
        this.main = main;
    }

    public NativeRegionSummationElementAmount getRoundContrast() {
        return roundContrast;
    }

    public void setRoundContrast(NativeRegionSummationElementAmount roundContrast) {
        this.roundContrast = roundContrast;
    }

    public NativeRegionSummationElementAmount getSameContrast() {
        return sameContrast;
    }

    public void setSameContrast(NativeRegionSummationElementAmount sameContrast) {
        this.sameContrast = sameContrast;
    }

    public BothSummationCompare getRoundCompare() {
        return roundCompare;
    }

    public void setRoundCompare(BothSummationCompare roundCompare) {
        this.roundCompare = roundCompare;
    }

    public BothSummationCompare getSameCompare() {
        return sameCompare;
    }

    public void setSameCompare(BothSummationCompare sameCompare) {
        this.sameCompare = sameCompare;
    }

    public StatisticsResultMeta getResultMeta() {
        return resultMeta;
    }

    public void setResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    public ForkQueryProcess getProcess() {
        return process;
    }

    public void setProcess(ForkQueryProcess process) {
        this.process = process;
    }
}
