package com.mini.framework.util.require;

import com.mini.framework.util.require.bean.FieldFinderTraversal;
import com.mini.framework.util.require.bean.MessageBuilder;
import com.mini.framework.util.require.bean.SwitchQueryer;


/**
 * 依赖建造者
 * @author jayheo
 *
 */
public class RequireBuilder {

	
	private RequireBuilder(){}

	/**
	 * 得到实例
	 * @param switchQueryer
	 * @param fieldFinderTraversal
	 * @return
	 */
	public static RequireBuilder getInstance(SwitchQueryer switchQueryer,FieldFinderTraversal fieldFinderTraversal){ 
		MessageBuilder.init(switchQueryer, fieldFinderTraversal);
		return new RequireBuilder();
	}
	
	
	/**
	 * 创建一个消息建造器
	 * @return
	 */
	public MessageBuilder createMessage(){
		return MessageBuilder.create();
	}
}
