package com.mini.framework.util.schedule;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.event.EventListener;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.log.MiniLogLevel;
import com.mini.framework.util.log.Event5WBuilder;

/**
 * 多商家定时分布
 * 
 * @author jayheo
 *
 */
public interface MultiSiteScheduleDispatchUtil {

	Logger logger = LogManager.getLogger(MultiSiteScheduleDispatchUtil.class);
	
	Map<String,HeartBeatCounter> taskMap = new ConcurrentHashMap<>();
	
	Map<String, Integer> siteTimePoints = new ConcurrentHashMap<>();
	
	/**
	 * 返回当前的商家id
	 * @return
	 */
	public Set<String> currSiteIds();
	
	default public Map<String,HeartBeatCounter> currentTaskMap(){
		return taskMap;
	}

	/**
	 * 根据方法找到方法的注解 SiteScheduled
	 * @param method
	 */
	default public void findAndPushTask(Method method) {
		SiteScheduled scheduled = method.getAnnotation(SiteScheduled.class);
		if(scheduled!=null){
			Event5WBuilder event = Event5WBuilder.event(3, "multiSiteDispatch").what("发现并注册定时任务:%s", method)
					.why("找到值为:[%s]的待执行方法", scheduled.taskId());
			logger.log(MiniLogLevel.getFrameWorkLog(),event);
			AssertUtil.assertSupport(!currentTaskMap().containsKey(scheduled.taskId()),"不允许存在一样任务id:%s",scheduled.taskId());
			assertMethodHadSpringEventListener(method, scheduled.taskId());
			//TODO 因为这个是基于spring的事件 ，所以还要注解和条件  @EventListener(condition="#task.taskId=='tryReflashWeixinServerToken'")

			int delay = scheduled.fixedDelay();
			int rate = scheduled.fixedRate();

			//TODO 要做检查

			if(scheduled.fixedDisturb()>0){
				delay += RandomUtils.nextInt(2 * scheduled.fixedDisturb()) - scheduled.fixedDisturb();
				rate += RandomUtils.nextInt(2 * scheduled.fixedDisturb()) - scheduled.fixedDisturb();
			}else if(scheduled.fixedDisturb() == 0){
				//什么都不做
			}else {
				throw new ServerException(Status.Server.programConfigJava,"SiteScheduled配置的fixedDisturb值错误",scheduled.fixedDisturb());
			}


			AssertUtil.assertNotFatal(delay > 0,"SiteScheduled配置 计算出来的delay:[%s]应该大于0,%s",delay,scheduled);
			AssertUtil.assertNotFatal(rate > 0,"SiteScheduled配置 计算出来的rate:[%s]应该大于0,%s",rate,scheduled);

			currentTaskMap().put(scheduled.taskId(),new HeartBeatCounter(delay, rate));
		}
	}
	
	default void assertMethodHadSpringEventListener(Method method,String taskId){
		AssertUtil.assertMethodRequire(method, "method");
		EventListener eventListener = method.getAnnotation(EventListener.class);
		//不能少了这个注解 EventListener
		AssertUtil.assertSupport(eventListener!=null, "方法%s必须有事件监听注解", method);
		String condition = eventListener.condition();
		AssertUtil.assertSupport(condition.equals(String.format("#task.taskId=='%s'", taskId)), "方法%s上的事件监听条件必须与SiteScheduled标记的:[%s]一致",method, taskId);
		//如果这里检查出现异常必须马上修改bug
	}
	
	
	

	/**
	 * 心跳一下返回下次的执行的任务
	 * @return
	 */
	default public Collection<SimpleCurrSiteIdTask> heartbeat() {
/*		return currentTaskMap().entrySet().stream()
				.filter(entry->entry.getValue().nextHeartbeat())
				.map(entry->entry.getKey()).collect(Collectors.toList());
		
		*/
		
		List<SimpleCurrSiteIdTask> tasks = new ArrayList<>();
		for (Entry<String, Integer> sitePoint : siteTimePoints.entrySet()) {
			String siteId = sitePoint.getKey();
			int timePoint = sitePoint.getValue();
			sitePoint.setValue(timePoint +1);
			for (Entry<String, HeartBeatCounter> entry : currentTaskMap().entrySet()) {
			String taskId =entry.getKey();
			HeartBeatCounter counter = entry.getValue();
				boolean match = counter.nextHeartbeat(timePoint);
				if(match){
					tasks.add(new SimpleCurrSiteIdTask(siteId,taskId));
				}
			}
		}
		return tasks;
	}
	
	
	default public void init(){
		Set<String> tempSiteIds = currSiteIds();
		tempSiteIds.forEach(siteId->{
			reflashSite(siteId);
		});
	}

	default void sureSite(String siteId){
		if(!siteTimePoints.containsKey(siteId)){
			siteTimePoints.put(siteId, 0);
		}
	}
	
	default void reflashSite(String siteId){
		siteTimePoints.put(siteId, 0);
	}

}
