package com.mini.framework.util.sql.view.able;

import java.util.Map;
import java.util.Optional;

/**
 * @author jayheo
 */
public interface ObjectValueReader {


    /**
     * 读取某个key
     * @param key
     * @return
     */
    Optional<Object> read(String key);


    /**
     * 创建一个读取器通过map
     * @param mapper
     * @return
     */
    static <T> ObjectValueReader create(Map<String,T> mapper){
        return new ObjectValueReader() {
            @Override
            public Optional<Object> read(String key) {

                return Optional.ofNullable(mapper.get(key));
            }
        };
    }

}
