package com.mini.framework.util.sql.view.bean;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.sql.view.able.ObjectValueReader;

import java.util.Date;
import java.util.Optional;

/**
 * 列的内值内容
 * @author jayheo
 */
public class ColumnValue extends SqlViewBean {

    /**
     * 关联的key
     */
    private String key;

    /**
     * 值类型
     */
    private ObjectStringValueType type;


    /**
     * 值
     */
    private String value;


    public static ColumnValue fromReader(ObjectValueReader reader, ColumnDefine define){
        Optional<Object> originValueOptional = reader.read(define.getKey());
        ColumnValue instance = new ColumnValue();
        instance.key = define.getKey();
        instance.type = define.getValueType();
        originValueOptional.ifPresent(originValue->{
            //TODO 根据数据类型得到值 以后要放到 ObjectStringValueType 枚举中去
            switch (instance.type){
                case date:
                    //TODO 这个断言要优化一下。
                    AssertUtil.assertNormal(originValue instanceof Date
                            ,()->new ServerException("key:[%s]对应的值类型是:[%s]无法解析成日期值为:[%s]",instance.key,originValue.getClass(),originValue));
                    instance.value = String.valueOf(((Date)originValue).getTime());
                    break;
                default:
                    instance.value = originValue.toString();
            }
        });
        return instance;
    }


    public String getKey() {
        return key;
    }

    public ColumnValue setKey(String key) {
        this.key = key;
        return this;
    }

    public ObjectStringValueType getType() {
        return type;
    }

    public ColumnValue setType(ObjectStringValueType type) {
        this.type = type;
        return this;
    }

    public String getValue() {
        return value;
    }

    public ColumnValue setValue(String value) {
        this.value = value;
        return this;
    }
}
