package com.mini.framework.util.string;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.util.asserts.AssertUtil;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinUtil {

	private static Logger logger = LogManager.getLogger(PinyinUtil.class);
	
	
	/**
	 * 返回拼音，如果是多音字直接返回第一个音。
	 * @param name
	 * @return
	 */
	public static String toFirstPinyin(String name) {
		HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
		String result = "";
		AssertUtil.assertMethodRequire(name, "name");
		for (int i = 0; i < name.length(); i++) {
			char c = name.charAt(i);
			String[] pys = null;
			try {
				pys = PinyinHelper.toHanyuPinyinStringArray(c, format);
			} catch (BadHanyuPinyinOutputFormatCombination e) {
				logger.debug("格式错误",e);
			}
			if(pys!=null && pys.length>0){
				String py = pys[0];
				result+= py.substring(0,py.length() - 1);
			}else if(c>='A'&&c<='Z' ){
				result+= String.valueOf(c);
			}else if(c>='a'&&c<='z'){
				result+=String.valueOf(c);
			}
		}
		result = result.toUpperCase();
		return result;
	}
	
	
	
	
}
