package com.mini.framework.util.string.bean;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.google.gson.Gson;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.GsonUtil;
import com.mini.framework.util.string.JsonEditUtil;
import com.mini.framework.util.string.StringUtil;

public class GsonStringNodeFormatItem {

	private String[] paths;

	/**
	 * 是不是被url加密码了。
	 */
	private Boolean urlEncode;

	public String[] getPaths() {
		return paths;
	}

	public void setPaths(String[] paths) {
		this.paths = paths;
	}

	public Boolean getUrlEncode() {
		return urlEncode;
	}

	public void setUrlEncode(Boolean urlEncode) {
		this.urlEncode = urlEncode;
	}
	public GsonStringNodeFormatItem(){}

	public GsonStringNodeFormatItem( Boolean urlEncode,String... paths) {
		super();
		this.urlEncode = urlEncode;
		this.paths = paths;
	}

	private static String removePreSuffix(String input,String match){
		String suffix = StringUtils.substringAfter(input, match).substring(1);
		String prefix = StringUtils.substringBefore(input, match);
		prefix = prefix.substring(0, prefix.length()-1);
		return prefix + match + suffix;
	}
	
	
	public String decode(String input) {
		String match  = JsonEditUtil.getJsonMapNamespaceValue(input, paths);
		if(match==null){
			return input;
		//TODO 对于上度为零的应该换成 {}不呢
		}else if(match.length()==0){
			return input;
		//TODO 对于 是不是要解析一下能 不能弄成gson 如果不能不解析
		}else{
			if(urlEncode!=null && urlEncode){
				String beanValue = StringUtil.urlDecode(match);
				String stringValue = toGsonElementString(beanValue);
				input = StringUtils.replaceOnce(input, match, stringValue);
			}
			match  = JsonEditUtil.getJsonMapNamespaceValue(input, paths);
			input = removePreSuffix(input, toGsonElementString(match));
			input = StringUtils.replaceOnce(input, toGsonElementString(match),match);
		}
		return input;
	}
	
	private static String toGsonElementString(String input){
		AssertUtil.assertMethodRequire(input, "input");
		Map<String, String> map = new HashMap<String, String>();
		map.put("a", input);
		String json = createGson().toJson(map);
		String result = json.substring(6, json.length()-2);
		return result;
	}
	
	private static Gson createGson(){
		return GsonUtil.createBaseBuilder().create();
				
	}
	
}
