package com.mini.framework.util.string.gson.deserializer;

import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mini.framework.util.asserts.AssertUtil;

public interface UnknownTypeHelper {
	static Object parseUnknownTypeValue(Number number) {
		AssertUtil.assertMethodRequire(number,"number");
		String string = number.toString();
		if(StringUtils.isNumeric(number.toString())){
			long longValue = number.longValue();
			if(longValue>=0 && longValue<=Integer.MAX_VALUE){
				return number.intValue();
			}else if(longValue<=0 && longValue>=Integer.MIN_VALUE){
				return number.intValue();
			}else if(string.equals(String.valueOf(longValue))){
				return longValue;
			}else{
				return number.doubleValue();
			}
		}else{
			return number.doubleValue();
		}
	}
	
	
	default  void fillUnknownValueToMap(JsonElement json,Map<String, Object> map){
        JsonObject jsonObject = json.getAsJsonObject();
        Set<Map.Entry<String, JsonElement>> entrySet = jsonObject.entrySet();
        for (Map.Entry<String, JsonElement> entry : entrySet) {
        	String key = entry.getKey();
        	Object value = entry.getValue();
        	if(value instanceof JsonElement){
        		if(((JsonElement) value).isJsonPrimitive()){
        			JsonPrimitive primitive = ((JsonElement) value).getAsJsonPrimitive();
        			if(primitive.isNumber()){
        				Number number = primitive.getAsNumber();
        				//value = Optional.ofNullable(number).map(UnknownTypeHelper::parseUnknownTypeValue).orElse(null);
						map.put(key, UnknownTypeHelper.parseUnknownTypeValue(number));
        			}
        		}
        	}
        };
	}
}

