package com.mini.framework.util.string.gson.format;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.mini.framework.util.string.gson.format.bean.Concat;
import com.mini.framework.util.string.gson.format.bean.Fill;
import com.mini.framework.util.string.gson.format.bean.Json;
import com.mini.framework.util.string.gson.format.bean.Mapper;
import com.mini.framework.util.string.gson.format.bean.Merge;
import com.mini.framework.util.string.gson.format.bean.MergeList;
import com.mini.framework.util.string.gson.format.bean.Remove;
import com.mini.framework.util.string.gson.format.bean.Rename;
import com.mini.framework.util.string.gson.format.bean.Retain;
import com.mini.framework.util.string.gson.format.bean.Union;

/**
 * 响应格式化的别名
 * 对于一些比较长的表达示可以直接写到服务端
 * @author jayheo
 *
 */
@Target(ElementType.METHOD)
 @Retention(RetentionPolicy.RUNTIME)
 @Documented
public @interface FormatAlias{

	/**
	 * 别名
	 * @return
	 */
	String alias();
	
	/**
	 * 响应表达式
	 * @return
	 */
	String[] explain() default {};

	/**
	 * 修改key的名字
	 * @return Rename
	 * */
	Rename[] rename() default {};

	/**
	 * json操作
	 * @return Rename
	 * */
	Json[] json() default {};

	/**
	 * 填充
	 * @return Fill
	 * */
	Fill[] fill() default {};
	
	/**
	 * 组合数据
	 * @return Merge
	 */
	Merge[] merge() default {};

	/**
	 * 组合多个数据。
	 * @return MergeList
	 * */
	MergeList[] mergeList() default {};

	/**
	 * 删除某个数据
	 * @return Remove
	 * */
	Remove[] remove()default {};
	/**
	 * 合并数据
	 * 合并后两个数据之前的字段是同级的
	 * @return Union
	 * */
	Union[] union()default {};

	/**
	 * 映射数据
	 * 从map中去找数据。
	 * @return Mapper
	 * */
	Mapper[] mapper() default {};

	/**
	 * 把两个数据连接到一起来
	 * */
	Concat[] concat() default{};

	/**
	 * 保留某些key
	 * */
	Retain[] retain() default {};
	
	String[] params() default {};
	
}
