package com.mini.framework.util.string.gson.format.bean;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * 将一个map的value值附加到一个list的对象中
 * @author jayheo
 *
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Mapper {

	/**
	 * 目标对象的路径。
	 * @return
	 */
	String targetPath();
	
	/**
	 * 目标对象中用于关联的key
	 * @return
	 */
	String targetKey();
	
	/**
	 * 源对应的路径
	 * 请务必保证源对象必须是一个map，否则可能出错
	 * @return
	 */
	String soursePath();

	/**
	 * 保留后的名字
	 * @return
	 */
	String alias();
	
}
