package com.mini.framework.util.surplus.reduce;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 剩余量预先准备扣减的的队列
 * @param <K> 用户描述数据的数据库id，一般是Integer或者Long等
 * @author jayheo
 */
public interface SurplusReduceCacheQueue<K> {

    /**
     * 弹出一个item
     * */
    Optional<ReduceQueueItem> popItem(K key);


    /**
     * 弹出多个item已要达到条件的
     * @param satisfiedCondition 用来 检查是不是满意的条件
     * */
    Optional<List<ReduceQueueItem>> popSatisfiedItems(K key, int size, Predicate<ReduceQueueItem> satisfiedCondition);


    /**
     * 推入一个item
     * */
    void pushItem(K key, ReduceQueueItem item);


    /**
     * 批量推入
     * */
    void batchPushItem(K key,List<ReduceQueueItem> itemArray);


    /**
     * 批量推入 
     * */
    default void batchPushItem(K key, Stream<ReduceQueueItem> itemArrayStream){
        batchPushItem(key,itemArrayStream.collect(Collectors.toList()));
    }


    /**
     * 返回对列当前的长度
     * */
    int queueSize(K key);


}
