package com.mini.framework.util.thread;

/**
 * 对象存储基类<br>
 * 用于存储对象到线程中<br>
 * 这个方法对于存一些全局要用的obj很有用<br>
 * 对于每个一个需要这个存储对象可以继承这个类
 * @author jayheo
 * TODO 对于web容器，或者mq等都会使用线程复用。所以作用域不是线程的需要再封装一层。
 * TODO https://blog.csdn.net/ni357103403/article/details/51970748 父子线程。
 */
public abstract class AbstractObjectThreadHold<O> implements ObjectThreadCachable<O> {

	protected ThreadLocal<O> local = new ThreadLocal<O>();

	public O get() {
		return local.get();
	}

	public void set(O obj) {
		local.set(obj);
	}


	public void clear(){
		local.remove();
	}

	@Override
	public void begin() {
		clear();
	}
}
