package com.mini.framework.util.thread;

import com.mini.framework.util.asserts.AssertUtil;

import java.util.ArrayList;
import java.util.List;


/**
 * 步线程上下文继承。
 */
public class AsyncThreadContextExtends {

    private final List<ContextTransfer<Integer>> intContextTransfers;
    private final List<ContextTransfer<Long>> longContextTransfers;
    private final List<ContextTransfer<Object>> objectContextTransfers;
    private final List<ContextTransfer<String>> stringContextTransfers;

    public AsyncThreadContextExtends(List<ContextTransfer<Integer>> intContextTransfers, List<ContextTransfer<Long>> longContextTransfers, List<ContextTransfer<Object>> objectContextTransfers, List<ContextTransfer<String>> stringContextTransfers) {

        this.intContextTransfers = intContextTransfers;
        this.longContextTransfers = longContextTransfers;
        this.objectContextTransfers = objectContextTransfers;
        this.stringContextTransfers = stringContextTransfers;

        AssertUtil.assertMethodRequire(intContextTransfers,"intContextTransfers");
        AssertUtil.assertMethodRequire(longContextTransfers,"longContextTransfers");
        AssertUtil.assertMethodRequire(objectContextTransfers,"objectContextTransfers");
        AssertUtil.assertMethodRequire(stringContextTransfers,"stringContextTransfers");
    }

    /**
     * 传输器
     */
    public static interface ContextTransfer<T> {
        T read();
        void write(T target);
    }


    /**
     * 上下文的缓存。
     */
    public static class ContextCache {

        private final List<Integer> intCaches;
        private final List<Long> longCaches;
        private final List<String> stringCaches;
        private final List<Object> objectCaches;

        private final AsyncThreadContextExtends contextExtends;


        private ContextCache(AsyncThreadContextExtends contextExtends){
            this.contextExtends = contextExtends;
            intCaches = new ArrayList<>();
            longCaches = new ArrayList<>();
            stringCaches = new ArrayList<>();
            objectCaches = new ArrayList<>();

            for (int index = 0; index < contextExtends.intContextTransfers.size(); index++) {
                ContextTransfer<Integer> intTransfer = contextExtends.intContextTransfers.get(index);
                intCaches.add(intTransfer.read());
            }
            for (int index = 0; index < contextExtends.longContextTransfers.size(); index++) {
                ContextTransfer<Long> longTransfer = contextExtends.longContextTransfers.get(index);
                longCaches.add(longTransfer.read());
            }
            for (int index = 0; index < contextExtends.stringContextTransfers.size(); index++) {
                ContextTransfer<String> stringTransfer = contextExtends.stringContextTransfers.get(index);
                stringCaches.add(stringTransfer.read());
            }
            for (int index = 0; index < contextExtends.objectContextTransfers.size(); index++) {
                ContextTransfer<Object> objectTransfer = contextExtends.objectContextTransfers.get(index);
                objectCaches.add(objectTransfer.read());
            }


        }

        public void applyToThread(){

            for (int index = 0; index < contextExtends.intContextTransfers.size(); index++) {
                ContextTransfer<Integer> intTransfer = contextExtends.intContextTransfers.get(index);
                Integer intCache = intCaches.get(index);
                intTransfer.write(intCache);
            }
            for (int index = 0; index < contextExtends.longContextTransfers.size(); index++) {
                ContextTransfer<Long> longTransfer = contextExtends.longContextTransfers.get(index);
                Long longCache = longCaches.get(index);
                longTransfer.write(longCache);
            }
            for (int index = 0; index < contextExtends.stringContextTransfers.size(); index++) {
                ContextTransfer<String> stringTransfer = contextExtends.stringContextTransfers.get(index);
                String intCache = stringCaches.get(index);
                stringTransfer.write(intCache);
            }
            for (int index = 0; index < contextExtends.objectContextTransfers.size(); index++) {
                ContextTransfer<Object> objectTransfer = contextExtends.objectContextTransfers.get(index);
                Object objectCache = objectCaches.get(index);
                objectTransfer.write(objectCache);
            }
        }


    }

    public ContextCache createFromMainThread(){
        return new ContextCache(this);
    }


    
}
