package com.mini.framework.util.thread;

import java.lang.reflect.Method;
import java.util.Optional;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.util.function.FinderStream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

import com.mini.framework.util.aspect.AspectBeanUtil;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.log.trace.LinkTraceFace;
import com.mini.framework.util.log.trace.MethodTracePointer;
import com.mini.framework.core.status.Status;

/**
 * aop注入商家
 * 他与ThreadAutoFollowMsg配合使用
 * @author jayheo
 */
public abstract class AsyncThreadMsgHandler {


	@Pointcut("@annotation(com.mini.framework.util.thread.ThreadAutoFollowMsg)")
	public void methodPointcut(){}
	
	
	@Before("methodPointcut()")
	public void autoFollowMsg(JoinPoint joinPoint){
	    Signature signature = joinPoint.getSignature();  
	    MethodSignature methodSignature = (MethodSignature)signature;  
	    Method targetMethod = methodSignature.getMethod();  
		getMethodTracePointer().autoPoint(targetMethod);
		Object siteKey = FinderStream.requireNotNull(new Object())
				.nextOptional(()->AspectBeanUtil.queryParamByAnnotation(joinPoint, ThreadSiteKey.class).map(o -> (Object) o))
				.nextOptional(()->AspectBeanUtil.queryParamByClass(joinPoint, HaveCurrSiteable.class).map(HaveCurrSiteable::getCurrSiteId))
				.find().orElseThrow(() -> new ServerException(Status.Server.programConfigJava, "没有从线程中得到商家id需要检查java方法:%s", AspectBeanUtil.getMethod(joinPoint)));
		getLocalThreadSiteId().set(String.valueOf(siteKey));
		LinkTraceFace.markSiteId(String.valueOf(siteKey));
	}

	public abstract ObjectThreadCachable<String> getLocalThreadSiteId();
	public abstract MethodTracePointer getMethodTracePointer();

}
