package com.mini.framework.util.thread;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.function.BiConsumer;

/**
 * 处理可运行的Runnable出现的异常。
 * @author jayheo
 */
public class RunnableThrowableHandler {

    private static Logger logger = LogManager.getLogger(RunnableThrowableHandler.class);

    /**
     * 装载成一个可以处理异常的Runnable
     * 打印错误日志
     * 命名错了，要换成下面的
     * @see #assignLoggerError(Runnable, String, Object[])
     * @param origin
     * @param message
     * @param params
     * @return
     */
    @Deprecated
    public static <O extends Object> Runnable assignLogError(Runnable origin,String message,O...params){
        return assignLoggerError(origin,message,params);
    }
    /**
     * 装载成一个可以处理异常的Runnable
     * 打印错误日志
     * @param origin
     * @param message
     * @param params
     * @return
     */
    public static <O extends Object> Runnable assignLoggerError(Runnable origin,String message,O...params){
        return assign(origin,(thread,error)->{
            String inputMessage = String.format(message, params);
            logger.error("single thread:[{}] throws {}:{}",thread.getName(),error.getClass(),inputMessage,error);
        });
    }


    /**
     * 装载成一个可以处理异常的Runnable
     * @param origin
     * @param errorHandler
     * @return
     */
    public static Runnable assign(Runnable origin, BiConsumer<Thread,Throwable> errorHandler){
        return ()-> {
            try{
                origin.run();
            }catch (Throwable error){
                errorHandler.accept(Thread.currentThread(),error);
                throw error;
            }
        };
    }


    //TODO 这里要提供一个方法，让runnable能够直接运行。
}
