package com.mini.framework.util.thread;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.concurrent.TimeUnit;

/**
 * 线程安静的睡眠
 * @author jayheo
 */
public class ThreadQuietSleep {

    private static Logger logger = LogManager.getLogger(ThreadQuietSleep.class);
    public static <P extends Object> void sleepMillisOrRun(long time,String message,P...params){
        try {
            TimeUnit.MILLISECONDS.sleep(time);
        } catch (InterruptedException e) {
            String threadName = Thread.currentThread().getName();
            String inputMessage = String.format(message,params);
            logger.error(String.format("thread:[%s]运运行失败,%s", threadName,inputMessage)  ,e);
        }
    }

}
