package com.mini.framework.util.version;

import java.io.File;
import java.util.Date;
import java.util.Optional;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.log.MiniLogLevel;
import com.mini.framework.core.status.Status;

public class PackageVersionUtil {

	private final static Logger logger = LogManager.getLogger();
	
	/**
	 * 时间关联版本
	 */
	private String dateVersionPattern;
	
	private String versionFormat;
	
	private String version;
	
	private Date createDate;

	private String[] roles = {"使用一个前缀，再根据jar包中时间生成后缀组成一个完整的版本说明"};
	
	public PackageVersionUtil(String versionFormat,String dateVersionPattern) {
		super();
		this.dateVersionPattern = dateVersionPattern;
		this.versionFormat = versionFormat;
	}

	public String getDateVersionPattern() {
		return dateVersionPattern;
	}


	public String getVersionFormat() {
		return versionFormat;
	}

	public String getVersion() {
		return version;
	}


	public Date getCreateDate() {
		return createDate;
	}

	public String[] getRoles() {
		return roles;
	}


	public PackageVersionUtil init(){
		createDate();
		version();
		return this;
	}
	

	/**
	 * 显示创建时间
	 * @return
	 */
	@Deprecated
	public Date createDate(){
		return showCreateDate().orElse(null);
	}

	/**
	 * 如果不是通过jar运行的得不到版本
	 * */
	public Optional<Date> showCreateDate(){
		if(createDate==null){
			createDate = packageDate().orElse(null);
		}
		return Optional.ofNullable(createDate);
	}

	/**
	 * 显示版本号
	 * 建议使用 @see #showVersion()
	 * @return
	 */
	@Deprecated
	public String version(){
		//无需要双判断
		return showVersion().orElse(null);
	}


	/**
	 * 显示版本号
	 * @return
	 */
	public Optional<String> showVersion(){
		//无需要双判断
		if(version==null){
			Optional<Date> createDateOptional = showCreateDate();
			if(createDateOptional.isPresent()){
				Date createDate = createDateOptional.get();
				String versionTemp = DateFormatUtils.format(createDate, dateVersionPattern);
				versionTemp = String.format(versionFormat, versionTemp);
				version = versionTemp;
			}
		}
		return Optional.ofNullable(version);
	}

	
	/**
	 * 得到包的时间，默认使用，包的生成时间
	 * @return
	 */
	protected Optional<Date> packageDate(){
		//String jarPath = System.getProperty("java.class.path");
		String currentJarPath = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
		//file:/D:/work/java/work11/tdt-api/tdt-bi/target/tdt-bi-1.0.0.jar!/BOOT-INF/lib/framework-util-1.0.6.4-SNAPSHOT.jar!/
		logger.log(MiniLogLevel.getFrameWorkLog(), "currentJarPath:{}",currentJarPath);
		String mainJarPath = StringUtils.substringBetween(currentJarPath, ":", "!");
		logger.log(MiniLogLevel.getFrameWorkLog(), "mainJarPath:{}",mainJarPath);

		if(mainJarPath==null){
			return Optional.empty();
		}else{
			File jarFile = new File(mainJarPath);
			long date = jarFile.lastModified();
			AssertUtil.simpleAssertByStatus(date>0, Status.Busy.bug, "得到文件:[%s]时间为0", jarFile);
			return Optional.of(new Date(date));
		}
	}


}
