/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.bean.desc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.bean.desc.DescSerializer;
import com.mini.framework.util.bean.desc.Descable;
import com.mini.framework.util.bean.desc.FieldDesc;
import com.mini.framework.util.bean.desc.FieldOptionDesc;
import com.mini.framework.util.bean.desc.RoleDesc;
import com.mini.framework.util.string.gson.DateMilliSecondSerializer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DescUtil {
    private static final String defaultDescPrefix = "-desc";

    private static String toJsonWithValue(Object object) {
        return DescUtil.toJsonWithValue(object, defaultDescPrefix);
    }

    private static String toJsonWithValue(Object object, String nameSuffix) {
        return DescUtil.buildGson().toJson(object);
    }

    private static Gson buildGson() {
        ArrayList<Gson> list = new ArrayList<Gson>();
        Supplier<Gson> gsonSupplier = () -> (Gson)list.get(0);
        GsonBuilder builder = new GsonBuilder().setDateFormat(1).registerTypeAdapter(Date.class, (Object)new DateMilliSecondSerializer()).registerTypeHierarchyAdapter(Descable.class, (Object)new DescSerializer(defaultDescPrefix, gsonSupplier, "\u672a\u53d1\u73b0\u63cf\u8ff0")).disableHtmlEscaping();
        Gson gson = builder.create();
        list.add(gson);
        return gson;
    }

    public static FieldDesc getDesces(Field field, String nullDesc) {
        Optional<Desc> descOptional = Optional.ofNullable(field.getAnnotation(Desc.class));
        Optional<RoleDesc> roleDescOptional = Optional.ofNullable(field.getAnnotation(RoleDesc.class));
        Class<?> type = field.getType();
        String typeName = type.getName();
        FieldDesc desc = new FieldDesc(field.getName(), typeName, descOptional.map(Desc::value).orElse(nullDesc), roleDescOptional.map(RoleDesc::required).orElse(null), roleDescOptional.map(RoleDesc::lengthLimit).orElse(null));
        if (null != type.getDeclaredAnnotation(Desc.class)) {
            desc.setTypeDesc(type.getDeclaredAnnotation(Desc.class).value());
        }
        if (type.isEnum()) {
            Field[] fields = type.getFields();
            fields[0].getName();
            List<FieldOptionDesc> options = Stream.of(fields).map(f -> FieldOptionDesc.fromField(f, nullDesc)).collect(Collectors.toList());
            desc.setOptions(options);
        }
        return desc;
    }
}

