/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.code;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MapperCodeUtil {
    public static final String chars62 = "oXrWOtAQgV6mzcaPG2LHdb4xJ7spFnShRk0q8iuYDlvKCZMyETIfwBUj3e1N95";
    public static final String chars36 = "ortg6mzca2db4x7spnhk0q8iulvyfwj3e195";
    public final int repeatDegree;
    public final long salt;
    public final int targetLength;
    public final String charItems;
    public final int useRadix;
    private Long useMax;
    private Integer useOffset;
    private Integer repeatTime;
    private Long shiftLength;

    public Long getUseMax() {
        return this.useMax;
    }

    public Integer getUseOffset() {
        return this.useOffset;
    }

    public Integer getRepeatDegree() {
        return this.repeatDegree;
    }

    public Integer getRepeatTime() {
        return this.repeatTime;
    }

    @Deprecated
    public static MapperCodeUtil createSimpleBinaray(int targetLength, int salt) {
        return MapperCodeUtil.createSimpleBinary(targetLength, salt);
    }

    public static MapperCodeUtil createSimpleBinary(int targetLength, int salt) {
        return MapperCodeUtil.create(targetLength, chars62, 2, 10, salt);
    }

    public static MapperCodeUtil createSimple36Binary(int targetLength, int salt) {
        return MapperCodeUtil.create(targetLength, chars36, 2, 10, salt);
    }

    public static MapperCodeUtil create(int targetLength, String charItems, int useRadix, int repeatDegree, long salt) {
        return new MapperCodeUtil(targetLength, charItems, useRadix, repeatDegree, salt);
    }

    public static MapperCodeUtil createChar36(int targetLength, int useRadix, int repeatDegree, long salt) {
        return new MapperCodeUtil(targetLength, chars36, useRadix, repeatDegree, salt);
    }

    private MapperCodeUtil(int targetLength, String charItems, int useRadix, int repeatDegree, long salt) {
        this.repeatDegree = repeatDegree;
        this.targetLength = targetLength;
        this.charItems = charItems;
        this.useRadix = useRadix;
        this.salt = salt;
        this.init();
    }

    private void init() {
        AssertUtil.assertNoBadReq(this.useRadix > 1, Status.BadReq.illParam, "useRadix:[%s]\u5fc5\u987b\u5927\u4e8e1", this.useRadix);
        long charCapacity = this.longPow(this.charItems.length(), this.targetLength);
        int offset = 0;
        while (this.longPow(this.useRadix, offset) <= charCapacity) {
            ++offset;
        }
        this.useOffset = offset - 1;
        this.repeatTime = this.primeNumber(this.repeatDegree);
        this.useMax = this.longPow(this.useRadix, this.useOffset);
        this.shiftLength = this.salt + this.useMax / 2L;
    }

    public String encode(long origin) {
        AssertUtil.assertNoBadReq(origin < this.useMax, Status.BadReq.hitLimit, "\u76ee\u6807:%s\u8d85\u8fc7\u4e86\u6700\u5927\u9650\u5236:%s", origin, this.useMax);
        for (int index = 0; index < this.repeatTime; ++index) {
            origin = this.stepCreate(origin);
        }
        return this.mapperCode(origin);
    }

    public long decode(String text) {
        AssertUtil.assertMethodRequire(text, "text");
        AssertUtil.assertNoBadReq(text.length() == this.targetLength, Status.BadReq.noReq, "text:[%s]\u957f\u5ea6:[%s]\u4e0e\u5f53\u524d\u957f\u5ea6\u4e0d\u7b26", text, this.targetLength);
        List<Integer> values = this.fromText(text);
        for (Integer value : values) {
            AssertUtil.assertNoBadReq(value >= 0, Status.BadReq.illParam, "text[%s]\u4e2d\u6709\u5b57\u7b26\u4e0d\u5728[%s]\u4e2d", text, this.charItems);
        }
        long origin = this.fromRadixOffsetValues(values, this.charItems.length());
        for (int index = 0; index < this.repeatTime; ++index) {
            origin = this.stepCreateRevoke(origin);
        }
        return origin;
    }

    private List<Integer> fromText(String text) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int index = 0; index < text.length(); ++index) {
            values.add(this.charItems.indexOf(text.charAt(index)));
        }
        return values;
    }

    protected long stepCreateRevoke(long origin) {
        long result = this.shiftRevoke(origin, this.shiftLength);
        result = this.reverseAsRadix(result, this.useRadix, this.useOffset);
        return result;
    }

    protected long stepCreate(long origin) {
        long result = this.reverseAsRadix(origin, this.useRadix, this.useOffset);
        result = this.shift(result, this.shiftLength);
        return result;
    }

    private String mapperCode(long origin) {
        return this.mapperCode(origin, this.charItems);
    }

    private String mapperCode(long origin, String chars) {
        List<Integer> offsetValues = this.toRadixOffsetValues(origin, chars.length());
        return offsetValues.stream().map(v -> chars.charAt((int)v) + "").collect(Collectors.joining(""));
    }

    protected long reverseAsRadix(long origin, int radix, int offset) {
        List<Integer> values = this.toRadixOffsetValues(origin, radix);
        while (values.size() < offset) {
            values.add(0, 0);
        }
        Collections.reverse(values);
        return this.fromRadixOffsetValues(values, radix);
    }

    protected long reverseAsRadixRevoke(long origin, int radix, int offset) {
        return this.reverseAsRadix(origin, radix, offset);
    }

    private List<Integer> toRadixOffsetValues(long origin, int radix) {
        long tempOrigin;
        ArrayList<Integer> offsetValues = new ArrayList<Integer>();
        for (tempOrigin = origin; (long)radix <= tempOrigin; tempOrigin /= (long)radix) {
            offsetValues.add((int)(tempOrigin % (long)radix));
        }
        offsetValues.add((int)tempOrigin);
        while (offsetValues.size() < this.targetLength) {
            offsetValues.add(0);
        }
        Collections.reverse(offsetValues);
        return offsetValues;
    }

    private long fromRadixOffsetValues(List<Integer> offsetValues, int radix) {
        long value = 0L;
        for (int index = 0; index < offsetValues.size(); ++index) {
            int offset = offsetValues.size() - index - 1;
            value += (long)offsetValues.get(index).intValue() * this.longPow(radix, offset);
        }
        return value;
    }

    private long longPow(int base, int times) {
        long result = 1L;
        for (int index = 0; index < times; ++index) {
            result *= (long)base;
        }
        double doublePow = Math.pow(base, times);
        AssertUtil.assertNotFatalBug(doublePow < 9.223372036854776E18, "long\u578b\u6c42\u6307\u6570\u53d1\u73b0base(%s)\u548cindex(%s)\u7ed3\u679c(%s)\u5927\u4e8e\u6700\u5927\u7684long(%s)", base, times, doublePow, Long.MAX_VALUE);
        AssertUtil.assertNotFatalBug((double)result > doublePow - 10.0, "long\u578b\u6c42\u6307\u6570\u53d1\u73b0base(%s)\u548cindex(%s)\u4e0d\u6ee1\u8db3 longPow(%s)>doublePow(%s)-10", base, times, result, doublePow);
        return result;
    }

    private long shift(long offset, long length) {
        return this.toRight(offset + length) % this.useMax;
    }

    private long shiftRevoke(long offset, long length) {
        return this.toRight(offset - length) % this.useMax;
    }

    private long toRight(long input) {
        while (input < 0L) {
            input += this.useMax.longValue();
        }
        return input % this.useMax;
    }

    public void reverseAsRadixTest(long input) {
        System.out.println(input);
        long result = this.reverseAsRadix(input, this.useRadix, this.useOffset);
        System.out.println(result);
        long result1 = this.reverseAsRadixRevoke(result, this.useRadix, this.useOffset);
        System.out.println(result1);
    }

    private int primeNumber(int index) {
        int[] primes = new int[]{5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 87, 97};
        AssertUtil.assertNoBadReq(index >= 0, Status.BadReq.hitLimit, "index:[%s]\u4e0d\u80fd\u5c0f\u5c110", index);
        AssertUtil.assertNoBadReq(index < primes.length, Status.BadReq.hitLimit, "index:[%s]\u5fc5\u987b\u5c0f\u4e8e\u53ef\u9009\u8d28\u6570\u6570", primes.length);
        return primes[index];
    }
}

