/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.colony;

import com.mini.framework.util.aspect.AspectBeanUtil;
import com.mini.framework.util.colony.DelayLockHelper;
import com.mini.framework.util.colony.SyncLockMethod;
import com.mini.framework.util.colony.SyncMethodKeyParam;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;

public class SinglePointOptAnnotationSupport {
    private Logger logger = LogManager.getLogger(SinglePointOptAnnotationSupport.class);
    private DelayLockHelper delayIncLockHelper;

    public SinglePointOptAnnotationSupport(DelayLockHelper delayIncLockHelper) {
        this.delayIncLockHelper = delayIncLockHelper;
    }

    @Pointcut(value="@annotation(com.mini.framework.util.colony.SyncLockMethod)")
    public void point() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="point()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        SyncLockMethod spMethod = AspectBeanUtil.getAnnotation((JoinPoint)pjp, SyncLockMethod.class);
        String key = spMethod.lockKey();
        List<String> params = AspectBeanUtil.listParam((JoinPoint)pjp, SyncMethodKeyParam.class).stream().map(SyncMethodKeyParam::showSyncKey).collect(Collectors.toList());
        params.add(0, key);
        String[] keys = params.toArray(new String[0]);
        int delay = spMethod.lockDelay();
        boolean lock = this.delayIncLockHelper.getLock(delay, keys);
        if (lock) {
            try {
                Object object = pjp.proceed();
                return object;
            }
            finally {
                if (spMethod.endRelease()) {
                    this.delayIncLockHelper.releaseLock(keys);
                }
            }
        }
        this.logger.debug("\u5206\u5e03\u5f0f\u9501key:{}\u88ab\u9501\u4f4f\u4e0d\u6267\u884c\u65b9\u6cd5", (Object)this.delayIncLockHelper.createKey(keys));
        return null;
    }
}

