/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.http;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.core.exception.HandleEnDeCodeException;
import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.params.MapParams;
import com.mini.framework.util.string.StringUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleHttpUtil {
    protected static final Logger logger = LogManager.getLogger(SimpleHttpUtil.class);
    protected static final String METHOD_POST_NAME = "POST";
    protected static final String METHOD_GET_NAME = "GET";
    protected static final String CHARSET_UTF8 = "utf-8";
    protected static RequestConfig defaultRequestConfig = SimpleHttpUtil.initDefaultRequestConfig();

    public static String simpleRequest(String url, String method, Map<String, String> params, Map<String, String> headers) {
        byte[] byteBuf = SimpleHttpUtil.simpleRequest(true, url, method, params, null, null);
        return StringUtil.toUtf8String(byteBuf);
    }

    private static RequestConfig initDefaultRequestConfig() {
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(6000);
        builder.setConnectionRequestTimeout(60000);
        builder.setSocketTimeout(12000);
        builder.setMaxRedirects(5);
        return builder.build();
    }

    public static String simpleRequest(String url, String method, String body, Map<String, String> headers) {
        byte[] byteBuf = SimpleHttpUtil.simpleRequest(false, url, method, null, body, headers);
        return StringUtil.toUtf8String(byteBuf);
    }

    private static byte[] simpleRequest(boolean keyAndValue, String url, String method, Map<String, String> params, String body, Map<String, String> headers) {
        logger.debug(String.format("http request,keyAndValue:%s,method:%s,url:%s,params:%s,body:%s,header:%s", keyAndValue, method, url, params, body, headers));
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        int status = 0;
        byte[] byteBuf = null;
        String result = null;
        CloseableHttpResponse resp = null;
        BasicHttpContext context = new BasicHttpContext();
        try {
            if (keyAndValue) {
                SimpleRequest request = new SimpleRequest(method, url);
                if (params != null) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        context.setAttribute(entry.getKey(), (Object)entry.getValue());
                    }
                }
                SimpleHttpUtil.buildHead(headers != null, (HttpRequest)request, headers);
                resp = closeableHttpClient.execute((HttpUriRequest)request, (HttpContext)context);
            } else {
                HttpPost httpPost = new HttpPost(url);
                httpPost.setConfig(defaultRequestConfig);
                StringEntity entity = new StringEntity(body, CHARSET_UTF8);
                httpPost.setEntity((HttpEntity)entity);
                SimpleHttpUtil.buildHead(headers != null, (HttpRequest)httpPost, headers);
                resp = closeableHttpClient.execute((HttpUriRequest)httpPost, (HttpContext)context);
            }
            status = resp.getStatusLine().getStatusCode();
            InputStream content = resp.getEntity().getContent();
            byteBuf = IOUtils.toByteArray((InputStream)content);
            result = StringUtil.toUtf8String(byteBuf);
            logger.debug(String.format("http status code:%s,result:%s", status, result));
        }
        catch (IOException e) {
            try {
                throw new HandleIOException((Throwable)e, "\u5728\u53d1http:[%s]\u8bf7\u6c42\u65f6\u51fa\u9519", new Object[]{url});
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resp);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)resp);
        if (200 <= status && 300 > status) {
            return byteBuf;
        }
        throw new HandleIOException("http-error,status:%s,url:%s", new Object[]{status, url});
    }

    public static String simplePost(String url, String body) {
        return SimpleHttpUtil.simpleRequest(url, METHOD_POST_NAME, body, null);
    }

    public static String simplePost(String url, String body, Map<String, String> headers) {
        return SimpleHttpUtil.simpleRequest(url, METHOD_POST_NAME, body, headers);
    }

    public static byte[] simpleBytePost(String url, String body) {
        byte[] byteBuf = SimpleHttpUtil.simpleRequest(false, url, METHOD_POST_NAME, null, body, null);
        return byteBuf;
    }

    public static String simplePost(String url, Map<String, String> params) {
        return SimpleHttpUtil.simpleRequest(url, METHOD_POST_NAME, params, null);
    }

    public static String simpleGet(String url, Map<String, String> params) {
        url = SimpleHttpUtil.assemGetRequestEncode(url, Optional.ofNullable(params));
        return SimpleHttpUtil.simpleRequest(url, METHOD_GET_NAME, (Map<String, String>)null, null);
    }

    protected static String assemGetRequestEncode(String url, Optional<Map<String, String>> paramsOptional) {
        if (!paramsOptional.isPresent()) {
            return url;
        }
        for (Map.Entry<String, String> entry : paramsOptional.get().entrySet()) {
            try {
                if (entry.getValue() == null) continue;
                String encode = URLEncoder.encode(entry.getValue(), CHARSET_UTF8);
                entry.setValue(encode);
            }
            catch (UnsupportedEncodingException e) {
                throw new HandleEnDeCodeException((Throwable)e, "getRequestEncode\u8f6c\u7801\u65f6\u51fa\u73b0\u5f02\u5e38,,entry:%s", new Object[]{entry});
            }
        }
        MapParams params = MapParams.build();
        params.putAll(paramsOptional.get());
        return params.toUrlParams(url);
    }

    public static String simplePost(String url) {
        return SimpleHttpUtil.simplePost(url, (Map<String, String>)null);
    }

    public static String simpleGet(String url) {
        return SimpleHttpUtil.simpleGet(url, null);
    }

    public static void buildHead(boolean explain, HttpRequest request, Map<String, String> headers) {
        if (explain) {
            headers.forEach((k, v) -> request.setHeader(k, v));
        }
    }

    protected static class SimpleRequest
    extends HttpRequestBase {
        private String method;

        public SimpleRequest(String method, String url) {
            this.method = method;
            this.setConfig(defaultRequestConfig);
            try {
                super.setURI(new URI(url));
            }
            catch (URISyntaxException e) {
                throw new BadReqException(Status.BadReq.illUrlSyntax, "url\u8bed\u6cd5\u9519\u8bef:%s", new Object[]{url});
            }
        }

        public String getMethod() {
            return this.method;
        }
    }
}

